package com.biz.crm.mdm.business.product.level.sdk.service;

import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelRelationDto;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelRelationVo;

import java.util.List;

/**
 * @Description 品项品类关系表
 * @Author YangWei
 * @Date 2023/2/13 上午11:34
 */
public interface ProductLevelRelationService {

    /**
     * 品项编码集合查询关系表
     * @param levelCodes
     * @return {@link List}<{@link ProductLevelRelationVo}>
     */
    List<ProductLevelRelationVo> findByProductLevelCode(List<String> productLevelCodes);

    /**
     * 批量保存新增关系表
     * @param saveReList
     * @param updateReList
     */
    void saveOrUpdateBatch(List<ProductLevelRelationDto> saveReList, List<ProductLevelRelationDto> updateReList);
}