package com.biz.crm.mdm.business.product.level.sdk.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.biz.crm.mdm.business.product.level.sdk.vo.MdgProductLevelVo;

/**
 * 产品层级接口1
 *
 * @author javadu1
 * @date 2021-09-27 14:13:56
 */
public interface ProductLevelService {
    /**
     * 批量新增或更新提交数据
     *
     * @param saveList
     * @param updateList
     * @return 数据
     */
    void saveOrUpdateBatch(List<MdgProductLevelVo> saveList, List<MdgProductLevelVo> updateList);

    /**
     * 根据编码集合查询已存在数据集合
     *
     * @param codeList 编码集合
     * @return java.util.Set<java.lang.String>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023.1.8 1:49
     */
    Map<String,String> findAllListByCodeList(List<String> codeList);
}
