package com.biz.crm.mdm.business.product.level.sdk.vo;

/**
 * @author javadu
 */

import com.biz.crm.business.common.sdk.vo.TenantTreeFlagOpVo;
import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.persistence.Column;/**1 * @program: crm
 * @description: 产品层级返回vo1
 * @author: Bao Hongbin
 * @create: 2021-10-08 16:42
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdgProductLevelVo", description = "产品层级返回vo")
public class MdgProductLevelVo extends TenantTreeFlagOpVo {

    private static final long serialVersionUID = 1559206001786747526L;
    @ApiModelProperty("上级产品层级编码")
    private String parentCode;
    @ApiModelProperty("上级产品层级名称")
    private String parentName;
    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("产品层级类型")
    private ProductLevelEnum productLevelType;

    @ApiModelProperty("数据来源")
    private String source;

    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;
}
