package com.biz.crm.mdm.business.product.level.sdk.vo;
/**
 * Created by Bao Hongbin on 2021-10-08 16:42.
 */

import com.biz.crm.business.common.sdk.vo.TenantTreeFlagOpVo;
import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @program: crm
 * @description: 产品层级返回vo
 * @author: Bao Hongbin
 * @create: 2021-10-08 16:42
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductLevelVo", description = "产品层级返回vo")
public class ProductLevelVo extends TenantTreeFlagOpVo {
  private static final long serialVersionUID = -3775915933091397464L;

  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  @ApiModelProperty("产品层级名称")
  private String productLevelName;

  @ApiModelProperty("产品层级类型")
  private ProductLevelEnum productLevelType;

  @ApiModelProperty("上级产品层级名称")
  private String parentName;

  @ApiModelProperty("上级产品层级编码")
  private String parentCode;

  @ApiModelProperty("来源")
  private String source;

  @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
  private String businessFormatCode;

  /**
   * 产品范围
   */
  @ApiModelProperty(name = "产品范围",notes = "产品范围")
  private List<TpmProductRangeVo> productRangeVoList;
}
