package com.biz.crm.mdm.business.product.level.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * (TpmProductRangeVo)
 * @author heding
 * @since 2022-12-26 15:19:51
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmProductRangeVo", description = "产品范围")
public class TpmProductRangeVo extends TenantFlagOpVo {

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code")
    private String productCode;


    /**
     * 产品名字
     */
    @ApiModelProperty("产品名字")
    @Column(name = "product_name")
    private String productName;

    /**
     * 品牌
     */
    @ApiModelProperty("产品品牌")
    @Column(name = "product_brand_name")
    private String productBrandName;
    /**
     * 品牌编码
     */
    @ApiModelProperty("产品品牌编码")
    @Column(name = "product_brand_code")
    private String productBrandCode;

    /**
     * 产品品类
     */
    @ApiModelProperty("产品品类")
    @Column(name = "product_category_name")
    private String productCategoryName;

    /**
     * 产品品项
     */
    @ApiModelProperty("产品品项")
    @Column(name = "product_level_name")
    private String productItemName;

    /**
     * 产品品类编码
     */
    @ApiModelProperty("产品品类编码")
    @Column(name = "product_category_code")
    private String productCategoryCode;


    /**
     * 产品品项编码
     */
    @ApiModelProperty("产品品项编码")
    @Column(name = "product_level_code")
    private String productItemCode;


}