package com.biz.crm.mdm.business.product.spu.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpu;
import com.biz.crm.mdm.business.product.spu.local.service.ProductSpuService;
import com.biz.crm.mdm.business.product.spu.sdk.dto.ProductSpuPaginationDto;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商品spu信息(ProductSpu)表控制层
 *
 * @author sunx
 * @date 2021-12-02 16:06:50
 */
@Slf4j
@Api(tags = "商品spu管理: ProductSpu: 商品spu管理")
@RestController
@RequestMapping(value = {"/v1/productSpu/productSpu"})
public class ProductSpuController {

  @Autowired(required = false) private ProductSpuService productSpuService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<ProductSpu>> findByConditions(
      @PageableDefault(50) Pageable pageable, ProductSpuPaginationDto paginationDto) {
    try {
      Page<ProductSpu> result = this.productSpuService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<ProductSpu> findDetailById(@RequestParam("id") String id) {
    try {
      List<ProductSpu> list = this.productSpuService.findDetailsByIds(Lists.newArrayList(id));
      if (CollectionUtils.isEmpty(list)) {
        return Result.error("未获取到详情信息");
      }
      return Result.ok(list.get(0));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param productSpu
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<ProductSpu> create(@RequestBody ProductSpu productSpu) {
    try {
      ProductSpu current = this.productSpuService.create(productSpu);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param productSpu
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<ProductSpu> update(@RequestBody ProductSpu productSpu) {
    try {
      ProductSpu current = this.productSpuService.update(productSpu);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result<?> enable(@RequestBody List<String> ids) {
    try {
      this.productSpuService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result<?> disable(@RequestBody List<String> ids) {
    try {
      this.productSpuService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 上架
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "上架")
  @PatchMapping("/upShelf")
  public Result<?> upShelf(@RequestBody List<String> ids) {
    try {
      this.productSpuService.upShelf(ids);
      return Result.ok("上架成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 下架
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "下架")
  @PatchMapping("/downShelf")
  public Result<?> downShelf(@RequestBody List<String> ids) {
    try {
      this.productSpuService.downShelf(ids);
      return Result.ok("下架成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result<?> delete(@RequestParam("ids") List<String> ids) {
    try {
      this.productSpuService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
