package com.biz.crm.mdm.business.product.spu.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商品spu管理
 *
 * @author sunx
 * @date 2021/12/3
 */
@Slf4j
@Api(tags = "商品spu管理: ProductSpuVo: 商品spu管理")
@RestController
@RequestMapping(value = {"/v1/productSpu/productSpu"})
public class ProductSpuVoController {

  @Autowired(required = false) private ProductSpuVoService productSpuVoService;

  /**
   * 根据spuCode集合获取spu主信息
   *
   * @param spuCodeList
   * @return
   */
  @ApiOperation(value = "根据spuCode集合获取spu主信息")
  @GetMapping(value = {"/findBySpuCodes"})
  public Result<List<ProductSpuVo>> findBySpuCodes(
      @RequestParam("spuCodeList") List<String> spuCodeList) {
    try {
      List<ProductSpuVo> list = this.productSpuVoService.findBySpuCodes(spuCodeList);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据spuCode集合获取spu全量关联明细
   *
   * @param spuCodeList
   * @return
   */
  @ApiOperation(value = "根据spuCode集合获取spu全量关联明细")
  @GetMapping(value = {"/findDetailsBySpuCodes"})
  public Result<List<ProductSpuVo>> findDetailsBySpuCodes(
      @RequestParam("spuCodeList") List<String> spuCodeList) {
    try {
      List<ProductSpuVo> list = this.productSpuVoService.findDetailsBySpuCodes(spuCodeList);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据商品编码获取关联的spu主信息
   *
   * @param productCodeList
   * @return
   */
  @ApiOperation(value = "根据商品编码获取关联的spu主信息")
  @GetMapping(value = {"/findRelateSpuMapByProductCodes"})
  public Result<Map<String, List<ProductSpuVo>>> findRelateSpuMapByProductCodes(
      @RequestParam("productCodeList") List<String> productCodeList) {
    try {
      Map<String, List<ProductSpuVo>> map =
          this.productSpuVoService.findRelateSpuMapByProductCodes(productCodeList);
      return Result.ok(map);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
