package com.biz.crm.mdm.business.product.spu.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商品spu关联的sku信息(ProductSpuRelateSku)实体类
 *
 * @author sunx
 * @since 2021-12-02 16:08:18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_product_spu_relate_sku")
@Table(
    name = "mdm_product_spu_relate_sku",
    indexes = {
      @Index(name = "mdm_product_spu_relate_sku1", columnList = "tenant_code"),
      @Index(name = "mdm_product_spu_relate_sku2", columnList = "spu_code"),
      @Index(name = "mdm_product_spu_relate_sku3", columnList = "product_code"),
    })
@ApiModel(value = "ProductSpuRelateSku", description = "商品spu关联的sku信息")
@org.hibernate.annotations.Table(
    appliesTo = "mdm_product_spu_relate_sku",
    comment = "商品spu关联的sku信息")
public class ProductSpuRelateSku extends TenantEntity {

  /** 商品spu编码 */
  @ApiModelProperty("商品spu编码")
  @TableField(value = "spu_code")
  @Column(name = "spu_code", length = 32, columnDefinition = "varchar(32) COMMENT '商品spu编码'")
  private String spuCode;

  /** 商品sku编码 */
  @ApiModelProperty("商品sku编码")
  @TableField(value = "product_code")
  @Column(name = "product_code", length = 32, columnDefinition = "varchar(32) COMMENT '商品sku编码'")
  private String productCode;

  /** 排序 */
  @ApiModelProperty("排序")
  @TableField(value = "sort")
  @Column(name = "sort", columnDefinition = "int COMMENT '排序'")
  private Integer sort;

  /** 商品sku名称 */
  @ApiModelProperty("商品sku名称")
  @TableField(exist = false)
  @Transient
  private String productName;

  /** 商品sku类型 */
  @ApiModelProperty("商品sku类型")
  @TableField(exist = false)
  @Transient
  private String productType;

  /** 产品层级 */
  @ApiModelProperty("产品层级")
  @TableField(exist = false)
  @Transient
  private String productLevelName;

  /** 规格 */
  @ApiModelProperty("规格")
  @TableField(exist = false)
  @Transient
  private String spec;

  /** 上下架状态 */
  @ApiModelProperty("上下架状态")
  @TableField(exist = false)
  @Transient
  private String isShelf;
}
