package com.biz.crm.mdm.business.product.spu.local.event;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.product.spu.sdk.enums.IsShelfEnum;
import com.biz.crm.mdm.business.product.spu.sdk.event.ProductSpuEventListener;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author yangshen
 * @version 1.0
 * @date 2022/12/27 15:09
 * @ClassName ProductSpuEventLogListener
 * @Description TODO 商品展示管理事件日志监听器
 */
@Component
public class ProductSpuEventLogListener implements ProductSpuEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    /**
     * 新建时触发
     *
     * @param vo
     */
    @Override
    public void onCreate(ProductSpuVo vo) {
        String onlyKey = vo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(null);
        crmBusinessLogDto.setNewObject(vo);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    @Override
    public void onUpdate(ProductSpuVo oldVo, ProductSpuVo newVo) {
        String onlyKey = newVo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(oldVo);
        crmBusinessLogDto.setNewObject(newVo);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }


    /**
     * 开启时触发
     *
     * @param list
     */
    @Override
    public void onEnable(List<ProductSpuVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(productSpuVo -> {
            String onlyKey = productSpuVo.getId();
            ProductSpuVo oldObj = new ProductSpuVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(productSpuVo.getEnableStatus());
            ProductSpuVo newObj = new ProductSpuVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(oldObj);
            crmBusinessLogDto.setNewObject(newObj);
            crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    /**
     * 禁用时触发
     *
     * @param list
     */
    @Override
    public void onDisable(List<ProductSpuVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(productSpuVo -> {
            String onlyKey = productSpuVo.getId();
            ProductSpuVo oldObj = new ProductSpuVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(productSpuVo.getEnableStatus());
            ProductSpuVo newObj = new ProductSpuVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(oldObj);
            crmBusinessLogDto.setNewObject(newObj);
            crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    /**
     * 删除时触发
     *
     * @param list
     */
    @Override
    public void onDelete(List<ProductSpuVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(productSpuVo -> {
            String onlyKey = productSpuVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(productSpuVo);
            crmBusinessLogDto.setNewObject(null);
            crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    /**
     * 上架时触发
     *
     * @param voList 新数据
     */
    @Override
    public void onUpShelf(List<ProductSpuVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        voList.forEach(productSpuVo -> {
            String onlyKey = productSpuVo.getId();
            ProductSpuVo oldObj = new ProductSpuVo();
            oldObj.setId(onlyKey);
            oldObj.setIsShelf(IsShelfEnum.DOWN.getCode());
            ProductSpuVo newObj = new ProductSpuVo();
            newObj.setId(onlyKey);
            newObj.setIsShelf(productSpuVo.getIsShelf());
            this.onUpdate(oldObj,newObj);
        });
    }

    /**
     * 下架时触发
     *
     * @param voList 新数据
     */
    @Override
    public void onDownShelf(List<ProductSpuVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        voList.forEach(productSpuVo -> {
            String onlyKey = productSpuVo.getId();
            ProductSpuVo oldObj = new ProductSpuVo();
            oldObj.setId(onlyKey);
            oldObj.setIsShelf(IsShelfEnum.UP.getCode());
            ProductSpuVo newObj = new ProductSpuVo();
            newObj.setId(onlyKey);
            newObj.setIsShelf(productSpuVo.getIsShelf());
            this.onUpdate(oldObj,newObj);
        });
    }
}
