package com.biz.crm.mdm.business.product.spu.local.service.internal;

import com.biz.crm.mdm.business.product.spu.local.entity.ProductSpuRelateSku;
import com.biz.crm.mdm.business.product.spu.local.repository.ProductSpuRelateSkuRepository;
import com.biz.crm.mdm.business.product.spu.sdk.service.ProductSpuRelateSkuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuRelateSkuVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/**
 * spu关联sku sdk实现
 *
 * @author sunx
 * @date 2021/12/2
 */
@Service
public class ProductSpuRelateSkuVoServiceImpl implements ProductSpuRelateSkuVoService {

  @Autowired(required = false) private ProductSpuRelateSkuRepository productSpuRelateSkuRepository;

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<ProductSpuRelateSkuVo> findBySpuCodes(List<String> spuCodeList) {
    if (CollectionUtils.isEmpty(spuCodeList)) {
      return Lists.newLinkedList();
    }
    List<ProductSpuRelateSku> list =
        this.productSpuRelateSkuRepository.findBySpuCodes(spuCodeList);
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newLinkedList();
    }

    return (List<ProductSpuRelateSkuVo>)
        this.nebulaToolkitService.copyCollectionByBlankList(
            list,
            ProductSpuRelateSku.class,
            ProductSpuRelateSkuVo.class,
            HashSet.class,
            ArrayList.class);
  }

  @Override
  public List<ProductSpuRelateSkuVo> findByProductCodes(List<String> productCodeList) {
    if (CollectionUtils.isEmpty(productCodeList)) {
      return Lists.newLinkedList();
    }
    List<ProductSpuRelateSku> list =
        this.productSpuRelateSkuRepository.findByProductCodes(productCodeList);
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newLinkedList();
    }

    return (List<ProductSpuRelateSkuVo>)
        this.nebulaToolkitService.copyCollectionByBlankList(
            list,
            ProductSpuRelateSku.class,
            ProductSpuRelateSkuVo.class,
            HashSet.class,
            ArrayList.class);
  }


}
