package com.biz.crm.mdm.business.table.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.table.feign.feign.ColumnConfigVoServiceFeign;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年12月27日 16:58:00
 */
@Component
@Slf4j
public class ColumnConfigVoServiceFeignImpl implements FallbackFactory<ColumnConfigVoServiceFeign> {
  @Override
  public ColumnConfigVoServiceFeign create(Throwable throwable) {
    log.error("进入CustomerAddressVoServiceFeign熔断", throwable);
    return new ColumnConfigVoServiceFeign() {
      @Override
      public Result<List<ColumnConfigVo>> findByParentCodeAndFunctionCodeOrderByFormorder(@RequestParam("parentCode")String parentCode, @RequestParam("functionCode")String functionCode) {
        throw new UnsupportedOperationException("查询MDM查询字段配置列表熔断");
      }
    };
  }
}
