package com.biz.crm.mdm.business.terminal.user.sdk.event;

import com.biz.crm.mdm.business.terminal.user.sdk.vo.TerminalUserVo;
import java.util.List;

/**
 * 终端用户变更事件通知接口
 *
 * @author sunx
 * @since 2021-10-20 16:37:36
 */
public interface TerminalUserEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(TerminalUserVo vo) {}

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(TerminalUserVo oldVo, TerminalUserVo newVo) {}

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<TerminalUserVo> list) {}

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<TerminalUserVo> list) {}

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<TerminalUserVo> list) {}
}
