package com.biz.crm.mdm.business.user.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.feign.feign.internal.UserPositionVoFeignFallbackImpl;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 用户信息feign接口类
 *
 * @author pengxi
 */
@FeignClient(
    name = "${feign.urlip:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = UserPositionVoFeignFallbackImpl.class
)
public interface UserPositionVoFeign {

  /**
   * 根据用户账号查询职位-用户关系
   * @param userName
   * @return
   */
  @ApiOperation(value = "根据用户账号查询职位-用户关系")
  @GetMapping(value = {"/v1/userPosition/userPosition/findByUserName"})
  Result<List<UserPositionVo>> findByUserName(@RequestParam("tenantCode") String tenantCode, @RequestParam("userName") String userName);

}
