package com.biz.crm.mdm.business.user.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.feign.feign.internal.UserRelDingTalkVoFeignFallbackImpl;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelDingTalkDto;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 用户和钉钉feign接口类
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.3 23:51
 */
@FeignClient(
        name = "${feign.urlip:crm-mdm}",
        path = "crm-mdm",
        fallbackFactory = UserRelDingTalkVoFeignFallbackImpl.class
)
public interface UserRelDingTalkVoFeign {


    /**
     * 新增(新增前会删除账号已关联信息)
     *
     * @param dtoList 新增信息
     * @return java.util.List<com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:47
     */
    @PostMapping(value = "/v1/userRelDingTalk/UserRelDingTalkVo/createBatch")
    Result<List<UserRelDingTalkVo>> createBatch(@RequestBody List<UserRelDingTalkDto> dtoList);

    /**
     * 根据ID集合解除账号关联钉钉信息
     *
     * @param ids ID集合
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    @DeleteMapping("/v1/userRelDingTalk/UserRelDingTalkVo/deleteByIds")
    Result<?> deleteByIds(@RequestParam("ids") List<String> ids);


    /**
     * 根据账号集合解除账号关联钉钉信息
     *
     * @param userNames 账号集合
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    @DeleteMapping("/v1/userRelDingTalk/UserRelDingTalkVo/deleteByUserNames")
    Result<?> deleteByUserNames(@RequestParam("userNames") List<String> userNames);

    /**
     * 根据钉钉ID集合解除账号关联钉钉信息
     *
     * @param dingTalkUserIds 钉钉ID集合
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    @DeleteMapping("/v1/userRelDingTalk/UserRelDingTalkVo/deleteByDingTalkUserIds")
    Result<?> deleteByDingTalkUserIds(@RequestParam("dingTalkUserIds") List<String> dingTalkUserIds);

    /**
     * 根据ID获取用户关联钉钉信息
     *
     * @param id ID
     * @return com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    @GetMapping(value = {"/v1/userRelDingTalk/UserRelDingTalkVo/findById"})
    Result<UserRelDingTalkVo> findById(@RequestParam("id") String id);

    /**
     * 根据钉钉ID获取用户关联钉钉信息
     *
     * @param dingTalkUserId 钉钉ID
     * @return java.util.List<com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    @GetMapping(value = {"/v1/userRelDingTalk/UserRelDingTalkVo/findByDingTalkUserId"})
    Result<List<UserRelDingTalkVo>> findByDingTalkUserId(@RequestParam("dingTalkUserId") String dingTalkUserId);


    /**
     * 根据钉钉ID获取用户关联钉钉信息
     *
     * @param dingTalkUserIds 钉钉ID
     * @return java.util.List<com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    @GetMapping(value = {"/v1/userRelDingTalk/UserRelDingTalkVo/findByDingTalkUserIds"})
    Result<List<UserRelDingTalkVo>> findByDingTalkUserIds(@RequestParam("dingTalkUserIds") List<String> dingTalkUserIds);

    /**
     * 根据账号获取用户关联钉钉信息
     *
     * @param userName 账号
     * @return java.util.List<com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    @GetMapping(value = {"/v1/userRelDingTalk/UserRelDingTalkVo/findByUserName"})
    Result<List<UserRelDingTalkVo>> findByUserName(@RequestParam("userName") String userName);

    /**
     * 根据账号集合获取用户关联钉钉信息
     *
     * @param userNames 账号集合
     * @return java.util.List<com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    @GetMapping(value = {"/v1/userRelDingTalk/UserRelDingTalkVo/findByUserNames"})
    Result<List<UserRelDingTalkVo>> findByUserNames(@RequestParam("userNames") List<String> userNames);

    /**
     * 根据账号集合获取用户关联钉钉信息
     * key userName
     * value 钉钉用户ID Set
     *
     * @param userNames 账号集合
     * @return java.util.List<com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    @ApiOperation(value = "根据账号集合获取用户关联钉钉信息")
    @GetMapping(value = {"/v1/userRelDingTalk/UserRelDingTalkVo/findMapByUserNames"})
    Result<Map<String, Set<String>>> findMapByUserNames(@RequestParam("userNames") List<String> userNames);

    /**
     * 根据账号获取用户和钉钉用户ID信息
     *
     * @param userName 账号
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.Set < java.lang.String>>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.5 11:34
     */
    @GetMapping(value = {"/v1/userRelDingTalk/UserRelDingTalkVo/findDingTalkUserIdByUserName"})
    Result<Set<String>> findDingTalkUserIdByUserName(@RequestParam("userNames") String userName);


    /**
     * 根据账号集合获取用户和钉钉用户ID信息
     *
     * @param userNames 账号集合
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.Set < java.lang.String>>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.5 11:34
     */
    @GetMapping(value = {"/v1/userRelDingTalk/UserRelDingTalkVo/findDingTalkUserIdByUserNames"})
    Result<Set<String>> findDingTalkUserIdByUserNames(@RequestParam("userNames") List<String> userNames);


}
