package com.biz.crm.mdm.business.user.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.feign.feign.UserInfoVoFeign;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 用户信息feign接口熔断类
 *
 * @author ning.zhang
 * @date 2022/5/10
 */
@Slf4j
@Component
public class UserInfoVoFeignFallbackImpl implements FallbackFactory<UserInfoVoFeign> {
  @Override
  public UserInfoVoFeign create(Throwable throwable) {
    return new UserInfoVoFeign() {
      @Override
      public Result<List<UserInfoVo>> findByPositionCodes(Set<String> positionCodes) {
        throw new UnsupportedOperationException("根据职位集合查询用户信息熔断");
      }

      @Override
      public Result<List<UserInfoVo>> findByLotPositionCodes(Set<String> positionCodes) {
        throw new UnsupportedOperationException("根据职位集合查询用户信息熔断");
      }

      @Override
      public Result<List<UserInfoVo>> findByUserNames(Set<String> userNames) {
        throw new UnsupportedOperationException("根据用户账号集合查询熔断");
      }

    };
  }
}
