package com.biz.crm.mdm.business.user.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.feign.feign.UserRelDingTalkVoFeign;
import com.biz.crm.mdm.business.user.sdk.dto.UserRelDingTalkDto;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 用户和钉钉feign接口熔断类
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.3 23:55
 */
@Slf4j
@Component
public class UserRelDingTalkVoFeignFallbackImpl implements FallbackFactory<UserRelDingTalkVoFeign> {
    @Override
    public UserRelDingTalkVoFeign create(Throwable throwable) {
        return new UserRelDingTalkVoFeign() {

            @Override
            public Result<List<UserRelDingTalkVo>> createBatch(List<UserRelDingTalkDto> dtoList) {
                throw new UnsupportedOperationException("批量用户与钉钉关系熔断");
            }

            @Override
            public Result<?> deleteByIds(List<String> ids) {
                throw new UnsupportedOperationException("通过ID集合解除用户与钉钉关系熔断");
            }

            @Override
            public Result<?> deleteByUserNames(List<String> userNames) {
                throw new UnsupportedOperationException("通过账号集合解除用户与钉钉关系熔断");
            }

            @Override
            public Result<?> deleteByDingTalkUserIds(List<String> dingTalkUserIds) {
                throw new UnsupportedOperationException("通过钉钉ID集合解除用户与钉钉关系熔断");
            }

            @Override
            public Result<UserRelDingTalkVo> findById(String id) {
                throw new UnsupportedOperationException("通过ID查询用户与钉钉关系熔断");
            }

            @Override
            public Result<List<UserRelDingTalkVo>> findByDingTalkUserId(String dingTalkUserId) {
                throw new UnsupportedOperationException("通过钉钉集合查询用户与钉钉关系熔断");
            }

            @Override
            public Result<List<UserRelDingTalkVo>> findByDingTalkUserIds(List<String> dingTalkUserIds) {
                throw new UnsupportedOperationException("通过钉钉ID集合查询用户与钉钉关系熔断");
            }

            @Override
            public Result<List<UserRelDingTalkVo>> findByUserName(String userName) {
                throw new UnsupportedOperationException("通过账号查询用户与钉钉关系熔断");
            }

            @Override
            public Result<List<UserRelDingTalkVo>> findByUserNames(List<String> userNames) {
                throw new UnsupportedOperationException("通过账号集合查询用户与钉钉关系熔断");
            }

            @Override
            public Result<Map<String, Set<String>>> findMapByUserNames(List<String> userNames) {
                throw new UnsupportedOperationException("通过账号集合查询用户与钉钉关系熔断");
            }

            @Override
            public Result<Set<String>> findDingTalkUserIdByUserName(String userName) {
                throw new UnsupportedOperationException("通过账号查询用户与钉钉用户ID信息熔断");
            }

            @Override
            public Result<Set<String>> findDingTalkUserIdByUserNames(List<String> userNames) {
                throw new UnsupportedOperationException("通过账号集合查询用户与钉钉用户ID信息熔断");
            }
        };
    }
}
