package com.biz.crm.mdm.business.user.feign.service.internal;

import com.biz.crm.mdm.business.user.feign.feign.UserVoFeign;
import com.biz.crm.mdm.business.user.sdk.dto.UserFeignDto;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * @author songjingen
 */
@Service("FeignUserFeignVoServiceImpl")
public class UserFeignVoServiceImpl implements UserFeignVoService {

  @Autowired(required = false)
  private UserVoFeign userVoFeign;

  @Override
  public Set<String> findUserNamesByUserDto(UserFeignDto dto) {
    return this.userVoFeign.findUserNamesByUserDto(dto).getResult();
  }

  @Override
  public List<UserVo> findByUserNames(List<String> userNames) {
    return this.userVoFeign.findByUserNames(userNames).getResult();
  }

  @Override
  public List<UserVo> findByLotUserNames(List<String> userNames) {
    return this.userVoFeign.findByLotUserNames(userNames).getResult();
  }
}
