package com.biz.crm.mdm.business.user.feign.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.user.feign.feign.UserVoFeign;
import com.biz.crm.mdm.business.user.sdk.dto.*;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import jodd.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * 用户信息服务接口实现类
 *
 * @author songjingen
 * @date 2022/3/2
 */
@Service("FeignUserVoServiceImpl")
public class UserVoServiceImpl implements UserVoService {

  @Autowired(required = false)
  private UserVoFeign userVoFeign;

  @Override
  public Set<String> findUserNamesByCodesAndUserType(List<String> orgCodes, List<String> positionLevelCodes, String userType) {
    return this.userVoFeign.findUserNamesByCodesAndUserType(orgCodes, positionLevelCodes, userType).getResult();
  }

  @Override
  public UserVo findDetailsByPhone(String phone) {
    return this.userVoFeign.findDetailsByPhone(phone).getResult();
  }

  @Override
  public UserVo findByPhone(String phone) {
    throw new UnsupportedOperationException();
  }

  @Override
  public Page<UserVo> findByConditions(Pageable pageable, UserPageDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public UserVo findDetailById(String id) {
    throw new UnsupportedOperationException();
  }

  @Override
  public UserVo findByUserName(String userName) {
    return this.userVoFeign.findByUserName(userName).getResult();
  }

  @Override
  public void create(UserDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void update(UserDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void enableBatch(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void disableBatch(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void updateDelFlagByIds(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void deleteUserLockByIds(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void updatePasswordByIds(UserForceChangePasswordDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void updatePasswordByUserName(UserChangePasswordDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public UserVo findRelationByUserNameAndOrgCodesOrOrgTypes(String userName, List<String> orgCodes, List<String> orgTypes) {
    return this.userVoFeign.findRelationByUserNameAndOrgCodesOrOrgTypes(userName, orgCodes, orgTypes).getResult();
  }

  @Override
  public Set<String> findUserNamesByUserConditionDto(UserConditionDto dto) {
    return this.userVoFeign.findUserNamesByUserConditionDto(dto).getResult();
  }

  @Override
  public Set<String> findPositionCodesByUserNames(List<String> userNames) {
    return this.userVoFeign.findPositionCodesByUserNames(userNames).getResult();
  }


  /**
   * 根据用户账号集合查询账号集合
   *
   * @param userNames 用户账号集合
   * @return java.util.Set<java.lang.String>
   * @author: huxmld
   * @version: v1.0.0
   * @date: 2022.12.3 23:13
   */
  @Override
  public Set<String> findUserNamesByUserNames(List<String> userNames) {
    if (CollectionUtil.isEmpty(userNames)) {
      return Collections.emptySet();
    }
    Result<Set<String>> result = this.userVoFeign.findUserNamesByUserNames(userNames);
    Assert.isTrue(result.isSuccess(), result.getMessage());
    return result.getResult();
  }

  @Override
  public void createMdgBatch(List<UserDto> saveList) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void updateMdgBatch(List<UserDto> updateList) {
    throw new UnsupportedOperationException();
  }

  @Override
  public List<UserVo> listByUserPhone(List<String> strings) {
    throw new UnsupportedOperationException();
  }

  @Override
  public List<UserVo> findUserByOrgCodes(List<String> orgCodeList) {
    return null;
  }

  /**
   * 按userName查询用户信息
   *
   * @param userNameList 用户
   * @return 用户列表
   */
  @Override
  public List<UserVo> findByUserNames(List<String> userNameList) {
    if (CollectionUtils.isEmpty(userNameList)) {
      return null;
    }
    Result<List<UserVo>> result = this.userVoFeign.findByUserNames(userNameList);
    Assert.isTrue(result.isSuccess(), result.getMessage());
    return result.getResult();
  }

  @Override
  public UserVo findUserAllMsgByUserName(String userName) {
    if (StringUtil.isBlank(userName)) {
      return null;
    }
    Result<UserVo> result = this.userVoFeign.findUserAllMsgByUserName(userName);
    Assert.isTrue(result.isSuccess(), result.getMessage());
    return result.getResult();
  }

}
