package com.biz.crm.mdm.business.user.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.user.sdk.dto.UserPositionPageDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserPositionDto;
import com.biz.crm.mdm.business.user.sdk.service.UserPositionVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * 职位-用户关联表(UserPosition)表控制层
 *
 * @author xi.peng
 * @since 2021-11-05 15:02:58
 */
@Slf4j
@Api(tags = "企业用户：UserPositionVo：职位-用户关联表")
@RestController
@RequestMapping(value = {"/v1/userPosition/userPosition"})
public class UserPositionVoController {

  @Autowired(required = false)
  private UserPositionVoService userPositionVoService;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 查询分页列表
   * @param pageable
   * @param dto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<UserPositionVo>> findByConditions(@PageableDefault(50) Pageable pageable, UserPositionPageDto dto) {
    try {
      Page<UserPositionVo> result = this.userPositionVoService.findByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<UserPositionVo> findDetailById(@RequestParam("id") String id) {
    try {
      UserPositionVo vo = this.userPositionVoService.findDetailById(id);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据用户账号查询职位-用户关系
   * @param userName
   * @return
   */
  @ApiOperation(value = "根据用户账号查询职位-用户关系")
  @GetMapping(value = {"/findByUserName"})
  public Result<List<UserPositionVo>> findByUserName(@RequestParam("tenantCode") String tenantCode, @RequestParam("userName") String userName) {
    try {
      List<UserPositionVo> userPositionVos = this.userPositionVoService.findByUserName(tenantCode, userName);
      return Result.ok(userPositionVos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   * @param dto
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<?> create(@RequestBody UserPositionDto dto) {
    try {
      this.userPositionVoService.create(dto);
      return Result.ok("创建成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   * @param dto
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<?> update(@RequestBody UserPositionDto dto) {
    try {
      this.userPositionVoService.update(dto);
      return Result.ok("更新成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新用户当前职位
   * @param dto
   * @return
   */
  @ApiOperation(value = "更新用户当前职位")
  @RequestMapping(value = "updateCurrentFlagPosition", method = {RequestMethod.PATCH,RequestMethod.POST})
  public Result<?> updateCurrentFlagPosition(@RequestBody UserPositionDto dto) {
    try {      
      // 切换上下文中的当前职位及角色集合
      this.loginUserService.refreshAuthentication(dto);
      return Result.ok("更新成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
