package com.biz.crm.mdm.business.user.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

/**
 * 用户表(User)实体类
 *
 * @author pengxi
 * @since 2021-11-04 16:46:37
 */

@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "mdm_user")
@TableName(value = "mdm_user")
@org.hibernate.annotations.Table(appliesTo = "mdm_user", comment = "用户表")
public class UserEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = 4442286383220798742L;

  /**
   * 用户账号登录信息
   */
  @TableField(value = "user_name")
  @Column(name = "user_name", length = 64, columnDefinition = "varchar(64) COMMENT '用户账号登录信息'")
  private String userName;

  /**
   * 用户编码
   */
  @TableField(value = "user_code")
  @Column(name = "user_code", length = 64, columnDefinition = "varchar(64) COMMENT '用户编码'")
  private String userCode;

  /**
   * 密码（经过加密的）
   */
  @TableField(value = "user_password")
  @Column(name = "user_password", length = 128, columnDefinition = "varchar(128) COMMENT '密码（经过加密的）'")
  private String userPassword;

  /**
   * 用户类型
   */
  @TableField(value = "user_type")
  @Column(name = "user_type", length = 32, columnDefinition = "varchar(32) COMMENT '用户类型'")
  private String userType;

  /**
   * 人员姓名
   */
  @TableField(value = "full_name")
  @Column(name = "full_name", length = 64, columnDefinition = "varchar(64) COMMENT '人员姓名'")
  private String fullName;

  /**
   * 性别
   */
  @TableField(value = "gender")
  @Column(name = "gender", length = 10, columnDefinition = "varchar(10) COMMENT '性别'")
  private String gender;

  /**
   * 电话
   */
  @TableField(value = "user_phone")
  @Column(name = "user_phone", length = 32, columnDefinition = "varchar(32) COMMENT '电话'")
  private String userPhone;

  /**
   * 生效时间
   */
  @TableField(value = "end_time")
  @Column(name = "end_time", length = 19, columnDefinition = "varchar(19) COMMENT '生效时间'")
  private String endTime;

  /**
   * 失效时间
   */
  @TableField(value = "start_time")
  @Column(name = "start_time", length = 19, columnDefinition = "varchar(19) COMMENT '失效时间'")
  private String startTime;

  /**
   * 邮箱
   */
  @TableField(value = "email")
  @Column(name = "email", length = 128, columnDefinition = "varchar(128) COMMENT '邮箱'")
  private String email;

  /**
   * 锁定状态 003/009
   */
  @TableField(value = "lock_state")
  @Column(name = "lock_state", length = 6, columnDefinition = "varchar(6) COMMENT '锁定状态 003/009'")
  private String lockState;

  /**
   * 最后一次登录时间
   */
  @TableField(value = "last_login_time")
  @Column(name = "last_login_time", length = 19, columnDefinition = "varchar(19) COMMENT '最后一次登录时间'")
  private String lastLoginTime;

  /**
   * 用户头像url
   */
  @TableField(value = "user_head_url")
  @Column(name = "user_head_url", length = 500, columnDefinition = "varchar(500) COMMENT '用户头像url'")
  private String userHeadUrl;

  /**
   * 是否强制修改密码
   */
  @TableField(value = "force_change_password")
  @Column(name = "force_change_password", length = 4, columnDefinition = "varchar(4) COMMENT '${column.comment}'")
  private Boolean forceChangePassword;

  /**
   * 工号
   */
  @TableField(value = "job_code")
  @Column(name = "job_code", length = 32, columnDefinition = "varchar(32) COMMENT '工号'")
  private String jobCode;

  /**
   * 员工类型
   */
  @TableField(value = "employee_type")
  @Column(name = "employee_type", length = 32, columnDefinition = "varchar(32) COMMENT '员工类型'")
  private String employeeType;

  /**
   * 员工状态
   */
  @TableField(value = "employee_status")
  @Column(name = "employee_status", length = 32, columnDefinition = "varchar(32) COMMENT '员工状态'")
  private String employeeStatus;

  /**
   * 身份证号码
   */
  @TableField(value = "identity_card_number")
  @Column(name = "identity_card_number", length = 32, columnDefinition = "varchar(32) COMMENT '身份证号码'")
  private String identityCardNumber;

  /**
   * 身份证地址
   */
  @TableField(value = "identity_card_address")
  @Column(name = "identity_card_address", length = 255, columnDefinition = "varchar(255) COMMENT '身份证地址'")
  private String identityCardAddress;

  /**
   * 民族
   */
  @TableField(value = "nationality")
  @Column(name = "nationality", length = 32, columnDefinition = "varchar(32) COMMENT '民族'")
  private String nationality;

  /**
   * 现住址
   */
  @TableField(value = "current_address")
  @Column(name = "current_address", length = 255, columnDefinition = "varchar(255) COMMENT '现住址'")
  private String currentAddress;

  /**
   * 政治面貌
   */
  @TableField(value = "political_affiliation")
  @Column(name = "political_affiliation", length = 128, columnDefinition = "varchar(128) COMMENT '政治面貌'")
  private String politicalAffiliation;

  /**
   * 每隔三个月修改密码更新时间
   */
  @TableField(value = "update_password_date")
  @Column(name = "update_password_date", length = 10, columnDefinition = "varchar(10) COMMENT '每隔三个月修改密码更新时间'")
  private Date updatePasswordDate;

  /**
   * 设备码
   */
  @TableField(value = "registration_id")
  @Column(name = "registration_id", length = 200, columnDefinition = "varchar(200) COMMENT '设备码'")
  private String registrationId;

}
