package com.biz.crm.mdm.business.user.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 职位-用户关联表(UserPosition)实体类
 *
 * @author pengxi
 * @since 2021-11-05 15:35:40
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "mdm_user_position")
@TableName(value = "mdm_user_position")
@ApiModel(value = "UserPosition", description = "职位-用户关联表")
@org.hibernate.annotations.Table(appliesTo = "mdm_user_position", comment = "职位-用户关联表")
public class UserPositionEntity extends TenantEntity {
  private static final long serialVersionUID = -5207620090098187258L;

  @ApiModelProperty("职位编码")
  @TableField(value = "position_code")
  @Column(name = "position_code", length = 32, columnDefinition = "varchar(32) COMMENT '职位编码'")
  private String positionCode;

  @ApiModelProperty("用户登录名")
  @TableField(value = "user_name")
  @Column(name = "user_name", length = 32, columnDefinition = "varchar(32) COMMENT '用户登录名'")
  private String userName;

  @ApiModelProperty("是否主职位 1是 0否")
  @TableField(value = "primary_flag")
  @Column(name = "primary_flag", length = 1, columnDefinition = "tinyint(1) COMMENT '是否主职位 1是 0否'")
  private Boolean primaryFlag;

  @ApiModelProperty("是否当前职位 1是 0否")
  @TableField(value = "current_flag")
  @Column(name = "current_flag", length = 1, columnDefinition = "tinyint(1) COMMENT '是否当前职位 1是 0否'")
  private Boolean currentFlag;

}
