package com.biz.crm.mdm.business.user.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.user.local.entity.UserPositionEntity;
import com.biz.crm.mdm.business.user.sdk.dto.UserPositionPageDto;
import com.biz.crm.mdm.business.user.sdk.vo.UserPositionVo;
import org.apache.ibatis.annotations.Param;

/**
 * 职位-用户关联表(UserPosition)表数据库访问层
 *
 * @author xi.peng
 * @since 2021-11-05 15:02:58
 */
public interface UserPositionMapper extends BaseMapper<UserPositionEntity> {
  
  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto  分页参数dto
   * @return 分页列表
   */
  Page<UserPositionVo> findByConditions(Page<UserPositionPageDto> page, @Param("dto") UserPositionPageDto dto);

}

