package com.biz.crm.mdm.business.user.local.service.internal;

import com.biz.crm.mdm.business.user.local.entity.UserEntity;
import com.biz.crm.mdm.business.user.local.entity.UserPositionEntity;
import com.biz.crm.mdm.business.user.local.repository.UserPositionRepository;
import com.biz.crm.mdm.business.user.local.repository.UserRepository;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 用户信息服务实现类
 *
 * @author xi.peng
 * @since 2021-11-05 15:02:58
 */
@Service
public class UserInfoVoServiceImpl implements UserInfoVoService {

  @Autowired(required = false)
  private UserPositionRepository userPositionRepository;

  @Autowired(required = false)
  private UserRepository userRepository;

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<UserInfoVo> findByPositionCodes(Set<String> positionCodes) {
    if (CollectionUtils.isEmpty(positionCodes)) {
      return Lists.newArrayList();
    }
    List<UserPositionEntity> userPositionEntities = this.userPositionRepository.findByPositionCodeIn(TenantUtils.getTenantCode(), positionCodes);
    return this.buildUserInfoVoList(userPositionEntities);
  }

  @Override
  public List<UserInfoVo> findByLotPositionCodes(Set<String> positionCodes) {
    return this.findByPositionCodes(positionCodes);
  }


  @Override
  public List<UserInfoVo> findByUserNames(Set<String> userNames) {
    if (CollectionUtils.isEmpty(userNames)) {
      return Lists.newArrayList();
    }
    List<UserPositionEntity> userPositionEntities = this.userPositionRepository.findByUserNames(TenantUtils.getTenantCode(), userNames);
    return this.buildUserInfoVoList(userPositionEntities);
  }

  /**
   * 根据用户职位关系构建用户信息vo列表
   */
  private List<UserInfoVo> buildUserInfoVoList(List<UserPositionEntity> userPositionEntities) {
    if (CollectionUtils.isEmpty(userPositionEntities)) {
      return Lists.newArrayList();
    }
    Set<String> userNames = userPositionEntities.stream().map(UserPositionEntity::getUserName).collect(Collectors.toSet());
    List<UserEntity> userEntities = this.userRepository.findByUserNames(TenantUtils.getTenantCode(), userNames);
    if (CollectionUtils.isEmpty(userEntities)) {
      return Lists.newArrayList();
    }
    // 构建用户信息带职位编码信息集合
    List<UserInfoVo> userInfoVoList = (List<UserInfoVo>) this.nebulaToolkitService.copyCollectionByWhiteList(userEntities, UserEntity.class, UserInfoVo.class, HashSet.class, ArrayList.class);
    Map<String, UserInfoVo> userInfoVoMap = userInfoVoList.stream().collect(Collectors.toMap(UserInfoVo::getUserName, v -> v));
    List<UserInfoVo> userInfoVos = Lists.newArrayList();
    userPositionEntities.forEach(up -> {
      if (userInfoVoMap.containsKey(up.getUserName())) {
        UserInfoVo userInfoVo = this.nebulaToolkitService.copyObjectByWhiteList(userInfoVoMap.get(up.getUserName()), UserInfoVo.class, HashSet.class, ArrayList.class);
        userInfoVo.setPositionCode(up.getPositionCode());
        userInfoVo.setPrimaryFlag(up.getPrimaryFlag());
        userInfoVos.add(userInfoVo);
      }
    });
    return userInfoVos;
  }
}
