package com.biz.crm.mdm.business.user.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;


/**
 * 用户表dto
 *
 * @author xi.peng
 * @since 2021-11-04 17:40:50
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "UserDto", description = "用户表dto")
public class UserFeignDto extends TenantFlagOpDto {

  /**
   * 用户账号
   */
  @ApiModelProperty("用户账号")
  private String userName;

  /**
   * 用户账号集合
   */
  @ApiModelProperty("用户账号集合")
  private List<String> userNames;

  /**
   * 用户编码
   */
  @ApiModelProperty("用户编码")
  private String userCode;


  /**
   * 用户类型
   */
  @ApiModelProperty("用户类型")
  private String userType;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String fullName;

  /**
   * 电话
   */
  @ApiModelProperty("电话")
  private String userPhone;

  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

}

