package com.biz.crm.mdm.business.user.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 职位-用户关联表dto
 *
 * @author xi.peng
 * @since 2021-11-05 15:01:46
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "UserPositionDto", description = "职位-用户关联表dto")
public class UserPositionDto extends TenantDto {

  @ApiModelProperty("组织编码")
  private String orgCode;

  @ApiModelProperty("职位级别编码")
  private String positionLevelCode;

  @ApiModelProperty("上级用户编码（拉取数据时使用）")
  private String parentUserName;

  @ApiModelProperty("数据来源（拉取数据时使用）")
  private String positionSource;

  @ApiModelProperty("上级职位编码")
  private String parentCode;

  @ApiModelProperty("上级MDG职位编码")
  private String mdgParentCode;

  @ApiModelProperty("职位编码")
  private String positionCode;

  @ApiModelProperty("职位名称")
  private String positionName;

  @ApiModelProperty("MDG职位编码")
  private String mdgPositionCode;

  @ApiModelProperty("MDG职位名称生成TPM职位名称后缀增长序列号（同一个mdg编码只有一条有数据）")
  private Integer suffixSequence;

  @ApiModelProperty("用户登录名")
  private String userName;

  @ApiModelProperty("是否主职位 1是 0否")
  private Boolean primaryFlag;

  @ApiModelProperty("是否当前职位 1是 0否")
  private Boolean currentFlag;

  @ApiModelProperty("是否新增职位")
  private Boolean operationType;

  @ApiModelProperty("职位关联角色")
  private List<String> roleCodeList;

}

