package com.biz.crm.mdm.business.user.sdk.enums;

/**
 * 用户类型枚举
 *
 * @author pengxi
 */
public enum UserSourceEnum {
  MDG("mdg", "数据中台mdg"),

  ;

  UserSourceEnum(String code, String desc) {
    this.code = code;
    this.desc = desc;
  }

  private String code;
  private String desc;

  public static UserSourceEnum getEnumByCode(String code) {
    if (code != null) {
      for (UserSourceEnum item :
          UserSourceEnum.values()) {
        if (item.getCode().equals(code)) {
          return item;
        }
      }
    }
    return null;
  }

  public static String getDescByCode(String code) {
    if (code != null) {
      UserSourceEnum anEnum = getEnumByCode(code);
      if (anEnum != null) {
        return anEnum.getDesc();
      }
    }
    return null;
  }

  public static boolean exist(String code) {
    if (code != null) {
      for (UserSourceEnum item :
          UserSourceEnum.values()) {
        if (item.getCode().equals(code)) {
          return true;
        }
      }
    }
    return false;
  }

  public String getCode() {
    return code;
  }


  public String getDesc() {
    return desc;
  }
}
