package com.biz.crm.mdm.business.user.sdk.event;

import com.biz.crm.mdm.business.user.sdk.vo.UserRelWeChatVo;
import java.util.List;

/**
 * 用户与微信关联表变更事件通知接口
 *
 * @author xi.peng
 * @since 2021-11-05 15:04:31
 */
public interface UserRelWeChatEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(UserRelWeChatVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(UserRelWeChatVo oldVo, UserRelWeChatVo newVo) {

  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<UserRelWeChatVo> list) {

  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<UserRelWeChatVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<UserRelWeChatVo> list) {

  }
}

