package com.biz.crm.mdm.business.user.sdk.service;

import com.biz.crm.mdm.business.user.sdk.dto.UserRelDingTalkDto;
import com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 用户与钉钉关联表(UserRelDingTalk)表服务接口
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.3 22:28
 */
public interface UserRelDingTalkVoService {

    /**
     * 新增(新增前会删除账号已关联信息)
     *
     * @param dtoList 新增信息
     * @return java.util.List<com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:47
     */
    List<UserRelDingTalkVo> createBatch(List<UserRelDingTalkDto> dtoList);

    /**
     * 根据ID集合解除账号关联钉钉信息
     *
     * @param ids ID集合
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    void deleteByIds(List<String> ids);

    /**
     * 根据账号集合解除账号关联钉钉信息
     *
     * @param userNameList 账号集合
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    void deleteByUserNames(List<String> userNameList);

    /**
     * 根据钉钉ID集合解除账号关联钉钉信息
     *
     * @param dingTalkUserIds 账号集合
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    void deleteByDingTalkUserIds(List<String> dingTalkUserIds);

    /**
     * 根据ID获取用户关联钉钉信息
     *
     * @param id ID
     * @return com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    UserRelDingTalkVo findById(String id);

    /**
     * 根据钉钉ID获取用户关联钉钉信息
     *
     * @param dingTalkUserId 钉钉ID
     * @return java.util.List<com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    List<UserRelDingTalkVo> findByDingTalkUserId(String dingTalkUserId);

    /**
     * 根据钉钉ID集合获取用户关联钉钉信息
     *
     * @param dingTalkUserIds 钉钉ID集合
     * @return java.util.List<com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    List<UserRelDingTalkVo> findByDingTalkUserIds(List<String> dingTalkUserIds);


    /**
     * 根据账号获取用户关联钉钉信息
     *
     * @param userName 账号
     * @return java.util.List<com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    List<UserRelDingTalkVo> findByUserName(String userName);


    /**
     * 根据账号集合获取用户关联钉钉信息
     *
     * @param userNameList 账号集合
     * @return java.util.List<com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    List<UserRelDingTalkVo> findByUserNames(List<String> userNameList);


    /**
     * 根据账号获取用户关联钉钉用户ID
     *
     * @param userName 账号
     * @return java.util.Set<java.lang.String>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.5 11:27
     */
    Set<String> findDingTalkUserIdByUserName(String userName);


    /**
     * 根据账号获取用户关联钉钉用户ID
     *
     * @param userNameList 账号集合
     * @return java.util.Set<java.lang.String>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.5 11:27
     */
    Set<String> findDingTalkUserIdByUserNames(List<String> userNameList);


    /**
     * 根据账号集合获取用户关联钉钉信息
     *
     * @param userNameList 账号集合
     * @return java.util.List<com.biz.crm.mdm.business.user.sdk.vo.UserRelDingTalkVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 22:43
     */
    Map<String, Set<String>> findMapByUserNames(List<String> userNameList);
}
