package com.biz.crm.mdm.business.user.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.user.sdk.dto.UserChangePasswordDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserForceChangePasswordDto;
import com.biz.crm.mdm.business.user.sdk.dto.UserPageDto;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import org.springframework.data.domain.Pageable;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 用户表(User)表服务接口
 *
 * @author xi.peng
 * @since 2021-11-04 17:38:46
 */
public interface UserVoService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<UserVo> findByConditions(Pageable pageable, UserPageDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  UserVo findDetailById(String id);

  /**
   * 按用户账号查询详情
   *
   * @param userName 用户帐号
   * @return
   */
  UserVo findByUserName(String userName);

  /**
   * 创建
   *
   * @param dto
   */
  void create(UserDto dto);

  /**
   * 更新
   *
   * @param dto
   */
  void update(UserDto dto);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 解锁
   *
   * @param ids
   */
  void deleteUserLockByIds(List<String> ids);

  /**
   * 强制修改密码
   *
   * @param dto
   */
  void updatePasswordByIds(UserForceChangePasswordDto dto);

  /**
   * 修改密码
   *
   * @param dto
   */
  void updatePasswordByUserName(UserChangePasswordDto dto);

  /**
   * 根据组织编码集合和职位级别集合和用户类型查询编码集合
   * 注意orgCodes和positionLevelCodes只允许有一个为空
   * {@link com.biz.crm.mdm.business.user.sdk.enums.UserTypeEnum}
   *
   * @param orgCodes           组织编码集合
   * @param positionLevelCodes 职位级别编码集合
   * @param userType           用户类型
   * @return 登录用户编码集合
   */
  default Set<String> findUserNamesByCodesAndUserType(List<String> orgCodes, List<String> positionLevelCodes, String userType) {
    return new HashSet<>();
  }

  /**
   * 按照用户手机号查询用户信息(包含职位和组织)
   *
   * @param phone 用户手机号
   * @return 用户信息
   */
  default UserVo findDetailsByPhone(String phone) {
    return null;
  }

  /**
   * 按手机号查询用户（新增有做系统中手机号唯一限制）
   *
   * @param phone 手机号
   * @return
   */
  UserVo findByPhone(String phone);

  /**
   * 检查用户账号与组织类型（层级）是否关联
   *
   * @param userName 用户账号
   * @param orgCodes 组织编码集合
   * @param orgTypes 组织类型（层级）集合
   * @return UserVo
   */
  UserVo findRelationByUserNameAndOrgCodesOrOrgTypes(String userName, List<String> orgCodes, List<String> orgTypes);

  /**
   * 根据用户多条件查询用户账号信息
   *
   * @param dto 参数dto
   * @return 用户账号信息
   */
  Set<String> findUserNamesByUserConditionDto(UserConditionDto dto);

  /**
   * 根据用户账号查询职位信息
   *
   * @param userNames
   * @return 职位编码集合
   */
  Set<String> findPositionCodesByUserNames(List<String> userNames);

  /**
   * 根据用户账号查询账号信息
   *
   * @param userNames 账号集合
   * @return 账号集合
   */
  Set<String> findUserNamesByUserNames(List<String> userNames);

  /**
   * 根据用户编码查询数据
   * @param userCodes
   * @return
   */
  default List<UserVo> findByUserCodes(Set<String> userCodes){return null;};

  /**
   * 批量新增（同步MDG数据专用）
   *
   * @author huojia
   * @date 2022/12/24 15:55
   * @param saveList
   **/
  void createMdgBatch(List<UserDto> saveList);

  /**
   * 批量编辑（同步MDG数据专用）
   *
   * @author huojia
   * @date 2022/12/24 17:38
   * @param updateList
   **/
  void updateMdgBatch(List<UserDto> updateList);

  /**
   * 根据手机号批量查询
   *
   * @author huojia
   * @date 2023/1/6 5:50
   * @param strings
   * @return java.util.List<com.biz.crm.mdm.business.user.sdk.vo.UserVo>
   **/
  List<UserVo> listByUserPhone(List<String> strings);

  /**
   * 查询指定组织下人员
   *
   * @param: * @param null
   * @return: * @return: null
   * @author: longhuajiang
   * @date: 2023/1/18
   */
  List<UserVo> findUserByOrgCodes(List<String> orgCodeList);

  /**
   * 按userName查询用户信息
   *
   * @param userNameList 用户
   * @return 用户列表
   */
  List<UserVo> findByUserNames(List<String> userNameList);

  /**
   * 按userName查询用户详细信息
   *
   * @param userName 用户账号
   * @return 用户信息
   */
  UserVo findUserAllMsgByUserName(String userName);
}
