package com.biz.crm.mdm.business.visitor.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.visitor.feign.feign.internal.VisitorAccountVoFeignFallbackImpl;
import com.biz.crm.mdm.business.visitor.sdk.vo.VisitorAccountVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 用户信息feign接口类
 *
 * @author xi.peng
 * @since 2022-08-30 17:22:27
 */
@FeignClient(
    name = "${feign.urlip:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = VisitorAccountVoFeignFallbackImpl.class
)
public interface VisitorAccountVoFeign {

  /**
   * 根据游客账号获取游客信息
   *
   * @param account 游客账号
   * @return 游客手机表Vo集合
   */
  @ApiOperation(value = "根据游客账号获取游客信息")
  @GetMapping(value = {"/v1/visitorAccount/visitorAccountVo/findByAccount"})
  Result<VisitorAccountVo> findByAccount(@RequestParam("account") String account);

  /**
   * 获取默认游客账号
   *
   * @return 默认游客账号
   */
  @ApiOperation(value = "获取默认游客账号")
  @GetMapping(value = {"/v1/visitorAccount/visitorAccountVo/findByDefaultAccount"})
  Result<VisitorAccountVo> findByDefaultAccount();
  
}
