package com.biz.crm.mn.third.system.alibaba.dingtalk.sdk.service;

import com.biz.crm.business.common.sdk.model.Result;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;

import java.util.List;

/**
 * 发送钉钉消息
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.23 17:29
 */
public interface DingTalkService {

    /**
     * 发送文本类型消息
     *
     * @param userId 钉钉用户ID/用户账号集合
     * @param msgContent      消息内容
     * @return com.biz.crm.business.common.sdk.model.Result
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.23 17:47
     */
    Result<OapiMessageCorpconversationAsyncsendV2Response> sendTextMsgByUserId(String userId, String msgContent);
    /**
     * 发送文本类型消息
     *
     * @param userIdList 钉钉用户ID/用户账号集合
     * @param msgContent      消息内容
     * @return com.biz.crm.business.common.sdk.model.Result
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.23 17:47
     */
    Result<OapiMessageCorpconversationAsyncsendV2Response> sendTextMsgByUserIdList(List<String> userIdList, String msgContent);

    /**
     * 获取钉钉token
     *
     * @return com.biz.crm.business.common.sdk.model.Result
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.29 12:32
     */
    Result<String> getDingTalkAccessToken();

    /**
     * 根据手机号获取userId
     *
     * @param mobile 手机号
     * @return java.lang.String
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.12.3 18:25
     */
    String getUserIdByMobile(String mobile);
}
