/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mn.third.system.cow.master.guest.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.auth.sdk.service.UrlApiService;
import com.biz.crm.mn.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.HttpCrmUtil;
import com.biz.crm.mn.common.log.sdk.dto.ForeignLogDetailDto;
import com.biz.crm.mn.common.log.sdk.service.ForeignLogVoService;
import com.biz.crm.mn.common.log.sdk.util.ForeignLogUtil;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.dto.CowMasterGuestInventoryDto;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.dto.CowMasterGuestMonthPlanDto;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.service.CowMasterGuestService;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.utils.BasicTokenUtil;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.vo.CowMasterGuestDataVo;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.vo.CowMasterGuestInventoryDataVo;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.vo.CowMasterGuestInventoryResultVo;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.vo.CowMasterGuestInventoryVo;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.vo.CowMasterGuestMonthPlanVo;
import com.biz.crm.mn.third.system.cow.master.guest.sdk.vo.CowMasterGuestResultVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CowMasterGuestServiceImpl
implements CowMasterGuestService {
    private static final Logger log = LoggerFactory.getLogger(CowMasterGuestServiceImpl.class);
    @Autowired(required=false)
    private UrlApiService urlApiService;
    @Autowired(required=false)
    private ForeignLogVoService foreignLogVoService;

    public List<CowMasterGuestMonthPlanVo> pullMonthPlanVo(CowMasterGuestMonthPlanDto dto) {
        CowMasterGuestResultVo cowMasterGuestResultVo;
        CowMasterGuestDataVo data;
        List records;
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getYear(), (String)"\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getMonths(), (String)"\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Result<String> result = this.monthPlanQuery(dto, dto.getCurrent(), dto.getSize());
        ArrayList<CowMasterGuestMonthPlanVo> planVoList = new ArrayList<CowMasterGuestMonthPlanVo>();
        if (result != null && result.isSuccess() && !StringUtils.isEmpty((CharSequence)((CharSequence)result.getResult())) && !CollectionUtils.isEmpty((Collection)(records = (data = (cowMasterGuestResultVo = (CowMasterGuestResultVo)JSONObject.parseObject((String)((String)result.getResult()), CowMasterGuestResultVo.class)).getData()).getRecords()))) {
            planVoList.addAll(records);
        }
        return planVoList;
    }

    private Result<String> monthPlanQuery(CowMasterGuestMonthPlanDto dto, Integer current, Integer size) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("year", (Object)dto.getYear());
        jsonObject.put("months", (Object)dto.getMonths());
        jsonObject.put("current", (Object)current);
        jsonObject.put("size", (Object)size);
        String json = JSON.toJSONString((Object)jsonObject);
        UrlAddressVo urlAddressVo = this.urlApiService.getUrlAddressByAccount("cow_master_guest");
        HashMap<String, String> headMap = this.getHeadMap(urlAddressVo);
        ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo((Object)json, (UrlAddressVo)urlAddressVo);
        detailDto.setMethod("/api/kasys-api/open/tpm/monthPlanQuery");
        detailDto.setMethodMsg("\u6708\u8ba1\u5212\u91cf");
        detailDto.setReqHead(JSON.toJSONString(headMap));
        this.foreignLogVoService.addOrUpdateLog(detailDto, true);
        Result result = HttpCrmUtil.post((String)(urlAddressVo.getUrl() + "/api/kasys-api/open/tpm/monthPlanQuery"), (String)json, headMap);
        ForeignLogUtil.buildLogResult((ForeignLogDetailDto)detailDto, (Object)result);
        this.foreignLogVoService.addOrUpdateLog(detailDto, false);
        return result;
    }

    private HashMap<String, String> getHeadMap(UrlAddressVo urlAddressVo) {
        long timeStamp = DateUtil.convertTimeStamp((Date)new Date());
        String basicToken = BasicTokenUtil.getBasicToken((long)timeStamp, (String)urlAddressVo.getAccessKey(), (String)urlAddressVo.getSecretKey());
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("token-auth", "basic " + basicToken);
        headMap.put("ts", String.valueOf(timeStamp));
        return headMap;
    }

    public List<CowMasterGuestInventoryVo> pullInventoryDataVo(CowMasterGuestInventoryDto dto, Integer current, Integer size) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getCreateDateStart(), (String)"\u5e93\u5b58\u63d0\u62a5\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getCreateDateEnd(), (String)"\u5e93\u5b58\u63d0\u62a5\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Result<String> result = this.inventoryReportQuery(dto, current, size);
        ArrayList<CowMasterGuestInventoryVo> voList = new ArrayList<CowMasterGuestInventoryVo>();
        if (result.isSuccess() && !StringUtils.isEmpty((CharSequence)((CharSequence)result.getResult()))) {
            CowMasterGuestInventoryResultVo cowMasterGuestResultVo = (CowMasterGuestInventoryResultVo)JSONObject.parseObject((String)((String)result.getResult()), CowMasterGuestInventoryResultVo.class);
            CowMasterGuestInventoryDataVo data = cowMasterGuestResultVo.getData();
            List records = data.getRecords();
            if (!CollectionUtils.isEmpty((Collection)records)) {
                voList.addAll(records);
            } else {
                return null;
            }
        }
        return voList;
    }

    private Result<String> inventoryReportQuery(CowMasterGuestInventoryDto dto, Integer current, Integer size) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("storeId", (Object)dto.getStoreId());
        jsonObject.put("sapCode", (Object)dto.getSapCode());
        jsonObject.put("prodDate", (Object)dto.getProdDate());
        jsonObject.put("createDateStart", (Object)dto.getCreateDateStart());
        jsonObject.put("createDateEnd", (Object)dto.getCreateDateEnd());
        jsonObject.put("current", (Object)current);
        jsonObject.put("size", (Object)size);
        String json = JSON.toJSONString((Object)jsonObject);
        UrlAddressVo urlAddressVo = this.urlApiService.getUrlAddressByAccount("cow_master_guest");
        HashMap<String, String> headMap = this.getHeadMap(urlAddressVo);
        ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo((Object)json, (UrlAddressVo)urlAddressVo);
        detailDto.setMethod("/api/kasys-api/open/tpm/inventoryReportQuery");
        detailDto.setMethodMsg("\u725b\u8981\u5ba2\u7ec8\u7aef\u5927\u65e5\u671f\u5e93\u5b58");
        detailDto.setReqHead(JSON.toJSONString(headMap));
        this.foreignLogVoService.addOrUpdateLog(detailDto, true);
        Result result = HttpCrmUtil.post((String)(urlAddressVo.getUrl() + "/api/kasys-api/open/tpm/inventoryReportQuery"), (String)json, headMap);
        ForeignLogUtil.buildLogResult((ForeignLogDetailDto)detailDto, (Object)result);
        this.foreignLogVoService.addOrUpdateLog(detailDto, false);
        return result;
    }
}

