/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mn.third.system.ecrm.local.service;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mn.common.auth.sdk.service.UrlApiService;
import com.biz.crm.mn.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.mn.common.log.sdk.dto.ForeignLogDetailDto;
import com.biz.crm.mn.common.log.sdk.service.ForeignLogVoService;
import com.biz.crm.mn.common.log.sdk.util.ForeignLogUtil;
import com.biz.crm.mn.third.system.ecrm.sdk.utils.Base64Utils;
import com.biz.crm.mn.third.system.ecrm.sdk.utils.RSAUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component
public abstract class ECrmBaseAuth {
    private static final Logger log = LoggerFactory.getLogger(ECrmBaseAuth.class);
    protected final ForeignLogVoService foreignLogVoService;
    protected final UrlApiService urlApiService;
    private static final String VERTICAL = "|";
    private static final String BEARER = "bearer ";
    private static final String API_AUTHORIZATION = "APIAuthorization";

    @Autowired
    public ECrmBaseAuth(ForeignLogVoService foreignLogVoService, UrlApiService urlApiService) {
        this.foreignLogVoService = foreignLogVoService;
        this.urlApiService = urlApiService;
    }

    protected <T> T postHttp(UrlAddressVo urlAddressVo, String method, String methodMsg, String body, Class<T> resultClass) {
        Validate.notEmpty((CharSequence)body);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String url = urlAddressVo.getUrl() + method;
        String publicKey = urlAddressVo.getSecretKey();
        long timeMillis = System.currentTimeMillis();
        ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo((Object)body, (UrlAddressVo)urlAddressVo);
        detailDto.setMethod(method);
        detailDto.setMethodMsg(methodMsg);
        JSONObject headJson = new JSONObject();
        try {
            String str = urlAddressVo.getAccessKey() + VERTICAL + RandomUtil.randomNumbers((int)10) + VERTICAL + timeMillis + VERTICAL + url + VERTICAL;
            String encode = Base64Utils.encode((byte[])RSAUtils.encryptByPublicKey((byte[])str.getBytes(), (String)publicKey));
            String finalStr = urlAddressVo.getAccessKey() + VERTICAL + encode;
            String authorization = BEARER + Base64Utils.encode((byte[])finalStr.getBytes());
            headJson.put(API_AUTHORIZATION, (Object)authorization);
            detailDto.setReqHead(headJson.toJSONString());
            this.foreignLogVoService.addOrUpdateLog(detailDto, true);
            HttpResponse httpResponse = ((HttpRequest)HttpRequest.post((String)url).header(API_AUTHORIZATION, authorization)).body(body).execute();
            String result = httpResponse.body();
            stopWatch.stop();
            detailDto.setRespJson(result);
            if (JSONUtil.isTypeJSON((String)result)) {
                JSONObject resultJson = JSONObject.parseObject((String)result);
                boolean success = resultJson.getBooleanValue("success");
                if (!success && !"0".equals(resultJson.getString("code"))) {
                    throw new RuntimeException("\u63a8\u9001ecrm\u9519\u8bef,\u53cd\u53c2:{" + result + "}");
                }
                detailDto.setStatus("S");
                detailDto.setTipMsg("\u64cd\u4f5c\u6210\u529f!");
                if (resultClass == null) {
                    T t = null;
                    return t;
                }
                Object object = JSONObject.parseObject((String)result, resultClass);
                return (T)object;
            }
            try {
                throw new RuntimeException("\u53cd\u53c2\u975ejson\u683c\u5f0f,\u65e0\u6cd5\u89e3\u6790,\u53cd\u53c2:{" + result + "}");
            }
            catch (Exception e) {
                detailDto.setExceptionStack(this.resolveExceptionStack(e));
                detailDto.setTipMsg(e.getMessage());
                log.error("\u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u5165\u53c2\uff1a{}, \u5f02\u5e38\u4fe1\u606f:{}", new Object[]{url, body, e.getMessage()});
                throw new RuntimeException(e.getMessage());
            }
        }
        finally {
            this.foreignLogVoService.addOrUpdateLog(detailDto, false);
        }
    }

    private String resolveExceptionStack(Exception e) {
        String expMessage;
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            e.printStackTrace(new PrintWriter(buf, true));
            expMessage = buf.toString();
            buf.close();
        }
        catch (IOException ex) {
            log.error("\u5f02\u5e38\u5806\u6808\u89e3\u6790\u5931\u8d25:{}", (Object)e, (Object)ex);
            expMessage = "\u5f02\u5e38\u5806\u6808\u89e3\u6790\u5931\u8d25\u3002";
        }
        return expMessage;
    }
}

