/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mn.third.system.ecrm.local.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.biz.crm.mn.common.auth.sdk.service.UrlApiService;
import com.biz.crm.mn.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.mn.common.log.sdk.service.ForeignLogVoService;
import com.biz.crm.mn.third.system.ecrm.local.service.ECrmBaseAuth;
import com.biz.crm.mn.third.system.ecrm.sdk.service.EcrmService;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.ApprovalStatementDto;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.ClosingStatementDto;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.DetailedForecastRequestVo;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.ECRMRespVo;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.PreEndResultRequestVo;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.SyncECrmStatementDto;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

@Service
public class ECrmServiceImpl
extends ECrmBaseAuth
implements EcrmService {
    public ECrmServiceImpl(ForeignLogVoService foreignLogVoService, UrlApiService urlApiService) {
        super(foreignLogVoService, urlApiService);
    }

    public void pushApprovalStatement(List<ApprovalStatementDto> approvalStatements) {
        UrlAddressVo urlAddressVo = this.urlApiService.getUrlAddressByAccount("ecrm_push_data");
        if (Objects.isNull(urlAddressVo)) {
            return;
        }
        super.postHttp(urlAddressVo, "/linkcrm/action/link/expenseStatementDetail/batchInmport", "\u63a8\u9001\u6279\u590d\u5bf9\u8d26\u5355", JSONObject.toJSONString(approvalStatements, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), null);
    }

    public void pushClosingStatement(List<ClosingStatementDto> closingStatements) {
        UrlAddressVo urlAddressVo = this.urlApiService.getUrlAddressByAccount("ecrm_push_data");
        if (Objects.isNull(urlAddressVo)) {
            return;
        }
        super.postHttp(urlAddressVo, "/linkcrm/action/link/costAccountDetail/batchInmport", "\u63a8\u9001\u7ed3\u6848\u5bf9\u8d26\u5355", JSONObject.toJSONString(closingStatements, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), null);
    }

    public void syncStatementECrm(SyncECrmStatementDto syncECrmStatementDto) {
        UrlAddressVo urlAddressVo = this.urlApiService.getUrlAddressByAccount("ecrm_push_data");
        if (Objects.isNull(urlAddressVo)) {
            return;
        }
        super.postHttp(urlAddressVo, "/linkcrm/action/link/electronicsign/callback", "\u540c\u6b65ECRM\u5bf9\u8d26\u5355\u72b6\u6001", JSONObject.toJSONString((Object)syncECrmStatementDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), null);
    }

    public boolean initiateSynchronization(List<DetailedForecastRequestVo> vos) {
        UrlAddressVo urlAddressVo = this.urlApiService.getUrlAddressByAccount("ecrm_push_data");
        if (Objects.isNull(urlAddressVo)) {
            return false;
        }
        vos.forEach(vo -> {
            Validate.notNull((Object)vo, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)vo.getIntegrationId(), (String)"\u96c6\u6210 ID \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)vo.getDetailPlanCode(), (String)"\u7ec6\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)vo.getDetailPlanName(), (String)"\u7ec6\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)vo.getDetailPlanItemCode(), (String)"\u7ec6\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)vo.getProcessStatus(), (String)"\u6d3b\u52a8\u7ec6\u6848\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)vo.getActivityTypeCode(), (String)"\u6d3b\u52a8\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)vo.getActivityTypeName(), (String)"\u6d3b\u52a8\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)vo.getActivityFormCode(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)vo.getActivityFormName(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)vo.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)vo.getActivityBeginTime(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)vo.getActivityEndTime(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        });
        ECRMRespVo o = super.postHttp(urlAddressVo, "/linkcrm/action/link/preWriteOff/batchInmport", "\u9884\u6838\u9500\u63a8\u9001", JSONObject.toJSONString(vos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), ECRMRespVo.class);
        return o.getSuccess();
    }

    public boolean synchronizationPreEndResultRequest(List<PreEndResultRequestVo> vos) {
        UrlAddressVo urlAddressVo = this.urlApiService.getUrlAddressByAccount("ecrm_push_data");
        if (Objects.isNull(urlAddressVo)) {
            return false;
        }
        ECRMRespVo o = super.postHttp(urlAddressVo, "/linkcrm/action/link/preEndResult/batchInmport", "\u9884\u6838\u7ed3\u6848\u7ed3\u679c\u63a8\u9001\u5931\u8d25", JSONObject.toJSONString(vos, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), ECRMRespVo.class);
        return o.getSuccess();
    }

    public static void main(String[] args) {
        ArrayList<ApprovalStatementDto> approvalStatements = new ArrayList<ApprovalStatementDto>();
        ApprovalStatementDto approvalStatementDto = new ApprovalStatementDto();
        approvalStatementDto.setActivityBeginDate(new Date());
        approvalStatementDto.setActivityEndDate(new Date());
        approvalStatementDto.setReconciliationMonth(new Date());
        approvalStatements.add(approvalStatementDto);
        System.out.println(JSONObject.toJSONString(approvalStatements, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
    }
}

