package com.biz.crm.mn.third.system.invoice.identify.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.invoice.identify.sdk.dto.InvoiceIdentifyCheckDto;
import com.biz.crm.mn.third.system.invoice.identify.sdk.dto.InvoiceIdentifyIdentifyDto;
import com.biz.crm.mn.third.system.invoice.identify.sdk.service.InvoiceIdentifyService;
import com.biz.crm.mn.third.system.invoice.identify.sdk.vo.InvoiceIdentifyCheckVo;
import com.biz.crm.mn.third.system.invoice.identify.sdk.vo.InvoiceIdentifyIdentifyVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.xml.bind.DatatypeConverter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/12/2 16:08
 * @description: 发票识别相关的http接口
 */
@Slf4j
@RestController
@RequestMapping("/v1/invoiceidentify")
@Api(tags = "发票识别验真", hidden = true)
public class InvoiceIdentifyController {

    @Autowired
    private InvoiceIdentifyService invoiceIdentifyService;

    /**
     * 发票验真
     *
     * @param dto 发票dto
     * @return 结果
     */
    @ApiOperation(value = "发票验真")
    @PostMapping(value = "checkInvoice")
    public Result<InvoiceIdentifyCheckVo> checkInvoice(@RequestBody InvoiceIdentifyCheckDto dto) {
        try {
            InvoiceIdentifyCheckVo checkVo = invoiceIdentifyService.checkInvoice(dto);
            return Result.ok(checkVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 发票识别
     *
     * @param dto 发票dto
     * @return 结果
     */
    @ApiOperation(value = "发票识别")
    @PostMapping(value = "identifyInvoice")
    public Result<List<InvoiceIdentifyIdentifyVo>> identifyInvoice(@RequestBody InvoiceIdentifyIdentifyDto dto) {
        try {
            List<InvoiceIdentifyIdentifyVo> list = invoiceIdentifyService.identifyInvoice(dto);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


//    /*
//     *actions: 将文件转成base64 字符串
//     *path：文件路径
//     */
//    public static String encodeBase64File(String path) throws Exception {
//        File file = new File(path);
//        FileInputStream inputFile = new FileInputStream(file);
//        byte[] buffer = new byte[(int) file.length()];
//        inputFile.read(buffer);
//        inputFile.close();
//        return new BASE64Encoder().encode(buffer);
//    }
//
//    public static void main(String[] args) throws Exception {
//        try {
//            File file = new File("D:\\data.txt");
//            if (!file.exists()) {
//                Boolean b = file.createNewFile(); // 创建新文件,有同名的文件的话直接覆盖        }
//                String str = encodeBase64File("C:\\Users\\chenlong\\Desktop\\7月\\滴滴电子发票310.19.pdf");
//                FileOutputStream fos = new FileOutputStream(file, true);
//                OutputStreamWriter osw = new OutputStreamWriter(fos);
//                BufferedWriter bw = new BufferedWriter(osw);
//                bw.write(str);
//                bw.newLine();
//                bw.flush();
//                bw.close();
//                osw.close();
//                fos.close();
//            }
//        } catch (IOException e1) {
//            e1.printStackTrace();
//        }
//    }


//    public static void main(String[] args) throws NoSuchAlgorithmException {
//        String str1 = "CESHI";
//        String str2 = DateUtil.dateStrNowAll();
//        String str3 = "341F5C0E7C03998EE97BDAC3717A5E49";
//        String str = str1 + str2 + str3;
//        MessageDigest md5 = MessageDigest.getInstance("MD5");
//        byte[] digest = md5.digest(str.getBytes(
//                StandardCharsets.UTF_8));
//        System.out.println(str2);
//        System.out.println(DatatypeConverter.printHexBinary(digest));
//    }
}
