package com.biz.crm.mn.third.system.master.data.mdg.sdk.service;

import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.*;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.*;

import java.util.List;

/**
 * @author huojia
 * @date 2022年12月05日 17:58
 */
public interface MasterDataMdgService {

    /**
     * 批量拉取 MDG 供应商数据
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgSupplierVo>
     * @author huojia
     * @date 2022/12/5 20:32
     **/
    List<MasterDataMdgSupplierVo> pullSupplierList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取 MDG 供应商银行数据
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgSupplierVo>
     * @author huojia
     * @date 2022/12/5 20:32
     **/
    List<MasterDataMdgSupplierBankVo> pullSupplierBankList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取 MDG 员工数据
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgUserVo>
     * @author huojia
     * @date 2022/12/5 20:32
     **/
    List<MasterDataMdgUserVo> pullUserList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取 MDG 部门数据
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgOrgVo>
     * @author huojia
     * @date 2022/12/5 20:32
     **/
    List<MasterDataMdgOrgVo> pullOrgList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取 MDG 岗位数据
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgPositionVo>
     * @author huojia
     * @date 2022/12/5 20:32
     **/
    List<MasterDataMdgPositionVo> pullPositionList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取 MDG 物料数据
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgMaterialVo>
     * @author dutaotao
     * @date 2022/12/5 20:32
     **/
    List<MasterDataMdgMaterialVo> pullMaterialList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取 MDG 物料单位主数据(MDG)
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgMaterialUnitVo>
     * @author dutaotao
     * @date 2022/12/5 20:32
     **/
    List<MasterDataMdgMaterialUnitVo> pullMaterialUnitList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取 MDG 客户主数据(MDG)
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgCustomerVo>
     * @author dutaotao
     * @date 2022/12/5 20:32
     **/
    List<MasterDataMdgCustomerVo> pullCustomerList(MasterDataMdgBaseDto dto);


    /**
     * 批量拉取 ECC 客户主数据(ECC)
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgClientVo>
     * @author dutaotao
     * @date 2022/12/5 20:32
     **/
    List<MasterDataMdgClientVo> pullClientList(MasterDataMdgBaseDto dto);


    /**
     * 批量拉取纬度主数据(MDG)
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgDimensionVo>
     * @author dutaotao
     * @date 2022/12/5 20:32
     **/
    List<MasterDataMdgDimensionVo> pullDimensionList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取客户银行主数据(MDG)
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgClientBankVo>
     * @author dutaotao
     * @date 2022/12/5 20:32
     **/
    List<MasterDataMdgClientBankVo> pullClientBankList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取公司地区和关系主数据(MDG)
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgCompanyAreaVo>
     * @author dutaotao
     * @date 2022/12/5 20:32 mdg_company_area_tpm
     **/
    List<MasterDataMdgCompanyAreaVo> pullCompanyAreaList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取组织渠道产品关系主数据(MDG)
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgOrganizeChannelProductVo>
     * @author dutaotao
     **/
    List<MasterDataMdgOrganizeChannelProductVo> pullOrganizeChannelProductList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取销售办公室关系主数据(MDG)
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgSalesOfficeVo>
     * @author dutaotao
     **/
    List<MasterDataMdgSalesOfficeVo> pullSalesOfficeList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取垂直门店主数据(MDG)
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgKmsDirectStoreVo>
     * @author wuxia
     **/
    List<MasterDataMdgKmsDirectStoreVo> pullKmsDirectStoreList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取KMS_POS数据(MDG)
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgKmsDirectStoreVo>
     * @author wuxia
     **/
    List<MasterDataMdgKmsPosVo> pullKmsPOSList(MasterDataPosDto dto);

    /**
     * 批量拉取KMS上架产品数据(MDG)
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgKmsDirectProductVo>
     * @author wuxia
     **/
    List<MasterDataMdgKmsDirectProductVo> pullKmsDirectProductList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取垂直门店主数据(MDG)
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgDimChlVo>
     * @author dutaotao
     **/
    List<MasterDataMdgDimChlVo> pullDimChlList(MasterDataMdgDimChlDto dto);

    /**
     * 批量拉取垂直销售业绩数据
     *
     * @param dto
     * @return
     */
    List<MasterDataMdgSalesPerformanceVo> pullSalesPerformance(MasterDataMdgSalesPerformanceDto dto);


    Integer getSalesPerformanceTotal(MasterDataMdgSalesPerformanceDto dto);

    /**
     * 分页查询车辆补贴汇总信息
     *
     * @param carSubsidyDto 车补贴请求dto
     * @return {@link List}<{@link MasterDataMdgCarSubsidyVo}>
     */
    List<MasterDataMdgCarSubsidyVo> pullCarSubsidy(MasterDataMdgCarSubsidyDto carSubsidyDto);


    /**
     * 分页查询车辆补贴明细信息
     *
     * @param carSubsidyDetailDto 车补贴明细请求dto
     * @return {@link List}<{@link MasterDataMdgCarSubsidyDetailVo}>
     */
    List<MasterDataMdgCarSubsidyDetailVo> pullCarSubsidyDetail(MasterDataMdgCarSubsidyDetailDto carSubsidyDetailDto);


    /**
     * 批量拉取分仓大日期库存数据(MDG)
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgInventoryVo>
     * @author heding
     */
    List<MasterDataMdgInventoryVo> pullTpmInventoryList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取销售日报数据
     *
     * @param dto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataSalesDayReportVo>
     * @author huojia
     * @date 2023/1/2 15:43
     **/
    List<MasterDataMdgSalesDayReportVo> pullSalesDayReportList(MasterDataMdgBaseDto dto);

    /**
     * @param code 接口地址
     * @return java.lang.Integer
     * @author huojia
     * @date 2023/1/8 1:07
     **/
    Integer countList(String code);

    /**
     * @param code  接口地址
     * @param ds    创建时间
     * @param udate 更新时间
     * @return java.lang.Integer
     * @author huojia
     * @date 2023/1/8 1:07
     **/
    Integer countList(String code, String ds, String udate);

    /**
     * 批量拉取KMS_POS数据(MDG)
     *
     * @param masterDataPosDto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgKmsDirectStoreVo>
     * @author wuxia
     **/
    List<MasterDataMdgKmsPosHuaRunVo> pullHuaRunKmsPOSList(MasterDataPosDto masterDataPosDto);

    Integer getPullHuaRunKmsPOSTotal(MasterDataPosDto masterDataPosDto);
    /**
     * 批量拉取KMS_POS数据(MDG)
     *
     * @param masterDataPosDto
     * @return java.util.List<com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgKmsDirectStoreVo>
     * @author wuxia
     **/
    List<MasterDataMdgKmsPosYongHuiVo> pullYongHuiKmsPOSList(MasterDataPosDto masterDataPosDto);

    Integer getPullYongHuiKmsPOSTotal(MasterDataPosDto masterDataPosDto);

    Integer getPullKmsPOSTotal(MasterDataPosDto dto);

    /**
     * KMS拉取105作废记录接口
     * @param dto
     * @return
     */
    List<MasterDataMdgDeleteDeliveryVo> pullDeleteDeliveryData(MasterDataMdgDeleteDeliverDto dto);

}