package com.biz.crm.mn.third.system.master.data.mdg.sdk.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 垂直销售业绩
 * @author yangshen
 * @version 1.0
 * @date 2023/1/9 11:07
 * @ClassName MasterDataSalesPerformance
 * @Description TODO
 */
@Data
public class MasterDataMdgSalesPerformanceVo {

    @ApiModelProperty(name = "冗余字段")
    private String spId;

    @ApiModelProperty(name = "日期")
    private String salesDate;

    @ApiModelProperty(name = "销售组织")
    private String salesOrg;

    @ApiModelProperty(name = "销售大区")
    private String region;

    @ApiModelProperty(name = "品牌")
    private String brand;

    @ApiModelProperty(name = "品项")
    private String categoryCode;

    @ApiModelProperty(name = "品类划分")
    private String classify;

    @ApiModelProperty(name = "产品名称")
    private String materialName;

    @ApiModelProperty(name = "产品类型（新品，主品等）")
    private String productType;

    @ApiModelProperty(name = "产品编码")
    private String materialCode;

    @ApiModelProperty(name = "运达方（送达方）")
    private String shipToparty;

    @ApiModelProperty(name = "送达方名称(门店名称)")
    private String shipTopartyName;

    @ApiModelProperty(name = "售达方名称")
    private String soldTopartName;

    @ApiModelProperty(name = "系统（售达方）")
    private String soldToparty;

    @ApiModelProperty(name = "零售商")
    private String retailer;

    @ApiModelProperty(name = "出库数量(收货订单数量)")
    private BigDecimal warehsOutQty;

    @ApiModelProperty(name = "出库折扣")
    private BigDecimal actualDiscount;

    @ApiModelProperty(name = "折前金额(订单含返点常规金额)")
    private BigDecimal orderRuleAmtInRebate;

    @ApiModelProperty(name = "折后实际销额")
    private BigDecimal warehsOutDiscountAmt;

    @ApiModelProperty(name = "月累出库数量(收货订单数量)")
    private BigDecimal warehsOutQtyIncM;

    @ApiModelProperty(name = "月累出库折扣")
    private BigDecimal actualDiscountIncM;

    @ApiModelProperty(name = "月累折前金额(订单含返点常规金额)")
    private BigDecimal orderRuleAmtInRebateIncM;

    @ApiModelProperty(name = "月累折后实际销额")
    private BigDecimal warehsOutDiscountAmtIncM;

    @ApiModelProperty(name = "年累出库数量(收货订单数量)")
    private BigDecimal warehsOutQtyIncY;

    @ApiModelProperty(name = "年累出库折扣")
    private BigDecimal actualDiscountIncY;

    @ApiModelProperty(name = "年累折前金额(订单含返点常规金额)")
    private BigDecimal orderRuleAmtInRebateIncY;

    @ApiModelProperty(name = "年累折后实际销额")
    private BigDecimal warehsOutDiscountAmtIncY;

    @ApiModelProperty("销售 年 yyyy")
    private String yearCol;

    @ApiModelProperty("销售 月份 yyyyMM")
    private String salesMonth;

    private String delFlag;

    private String enableStatus;

    private String tenantCode;
}
