/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mn.third.system.sd.local.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.auth.sdk.aop.SignHeader;
import com.biz.crm.mn.third.system.sd.sdk.dto.ect.EctPaymentCollectionDto;
import com.biz.crm.mn.third.system.sd.sdk.service.SapCallbackEctService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/pull/sap"})
@Api(tags={"SAP\u7cfb\u7edf\u63a8\u9001\u6570\u636e\u5230ECT"}, hidden=true)
public class SapCallbackEctController {
    private static final Logger log = LoggerFactory.getLogger(SapCallbackEctController.class);
    @Autowired(required=false)
    private SapCallbackEctService sapCallbackEctService;

    @ApiOperation(value="SAP\u56de\u6b3e\u63a5\u53e3")
    @PostMapping(value={"/paymentCollection"})
    @SignHeader
    public Result pull4paymentCollectionDto(@RequestBody JSONObject jsonObject) {
        try {
            String item = jsonObject.getString("ITEM");
            ArrayList<EctPaymentCollectionDto> dtos = new ArrayList<EctPaymentCollectionDto>();
            if (StringUtils.isNotBlank((CharSequence)item) && item.startsWith("[")) {
                JSONArray jsonArray = jsonObject.getJSONArray("ITEM");
                dtos.addAll(jsonArray.toJavaList(EctPaymentCollectionDto.class));
            } else if (StringUtils.isNotBlank((CharSequence)item) && item.startsWith("{")) {
                EctPaymentCollectionDto ectPaymentCollectionDto = (EctPaymentCollectionDto)JSONObject.parseObject((String)JSON.toJSONString((Object)jsonObject.get((Object)"ITEM")), EctPaymentCollectionDto.class);
                dtos.add(ectPaymentCollectionDto);
            }
            if (ObjectUtils.isNotEmpty(dtos)) {
                this.sapCallbackEctService.pull4paymentCollectionDto(dtos);
            }
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

