/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mn.third.system.sd.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.auth.sdk.service.UrlApiService;
import com.biz.crm.mn.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.HttpCrmUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.common.log.sdk.dto.ForeignLogDetailDto;
import com.biz.crm.mn.common.log.sdk.service.ForeignLogVoService;
import com.biz.crm.mn.common.log.sdk.util.ForeignLogUtil;
import com.biz.crm.mn.third.system.sd.sdk.dto.MessageHeaderDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.activity.CreatePromotionActivityBranchDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.activity.FreeGoodsInterfaceDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.activity.QueryPromotionActivityBranchDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.activity.UpdatePromotionActivityBranchDto;
import com.biz.crm.mn.third.system.sd.sdk.enums.ActivityPushSapInterfaceEnum;
import com.biz.crm.mn.third.system.sd.sdk.service.ActivityPushSapApiService;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityPushSapApiServiceImpl
implements ActivityPushSapApiService {
    private static final Logger log = LoggerFactory.getLogger(ActivityPushSapApiServiceImpl.class);
    private String host;
    private String accessId;
    private String accessKey;
    private String secretKey;
    private UrlAddressVo urlAddressVo;
    @Autowired(required=false)
    private ForeignLogVoService foreignLogVoService;
    @Autowired(required=false)
    private UrlApiService urlApiService;

    public Result pushCreatePromotionActivityBranch(CreatePromotionActivityBranchDto dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        MessageHeaderDto header = new MessageHeaderDto();
        header.setInterfacePath(ActivityPushSapInterfaceEnum.BRANCH_CREATE_ACTIVITY.getCode());
        header.setSender(ActivityPushSapInterfaceEnum.BRANCH_CREATE_ACTIVITY.getSender());
        header.setReceiver(ActivityPushSapInterfaceEnum.BRANCH_CREATE_ACTIVITY.getReceiver());
        header.setMessageId(UuidCrmUtil.general());
        header.setSendTime(DateUtil.date_yyyyMMddHHmmss.format(new Date()));
        dto.setMessageHeader(header);
        return this.sendActivityMsgToBranch(ActivityPushSapInterfaceEnum.BRANCH_CREATE_ACTIVITY, dto);
    }

    public Result pushUpdatePromotionActivityBranch(UpdatePromotionActivityBranchDto dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        MessageHeaderDto header = new MessageHeaderDto();
        header.setInterfacePath(ActivityPushSapInterfaceEnum.BRANCH_UPDATE_ACTIVITY.getCode());
        header.setSender(ActivityPushSapInterfaceEnum.BRANCH_UPDATE_ACTIVITY.getSender());
        header.setReceiver(ActivityPushSapInterfaceEnum.BRANCH_UPDATE_ACTIVITY.getReceiver());
        header.setMessageId(UuidCrmUtil.general());
        header.setSendTime(DateUtil.date_yyyyMMddHHmmss.format(new Date()));
        dto.setMessageHeader(header);
        return this.sendActivityMsgToBranch(ActivityPushSapInterfaceEnum.BRANCH_UPDATE_ACTIVITY, dto);
    }

    public Result pushQueryPromotionActivityBranch(QueryPromotionActivityBranchDto dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        MessageHeaderDto header = new MessageHeaderDto();
        header.setInterfacePath(ActivityPushSapInterfaceEnum.BRANCH_QUERY_ACTIVITY.getCode());
        header.setSender(ActivityPushSapInterfaceEnum.BRANCH_QUERY_ACTIVITY.getSender());
        header.setReceiver(ActivityPushSapInterfaceEnum.BRANCH_QUERY_ACTIVITY.getReceiver());
        header.setMessageId(UuidCrmUtil.general());
        header.setSendTime(DateUtil.date_yyyyMMddHHmmss.format(new Date()));
        dto.setMessageHeader(header);
        return this.sendActivityMsgToBranch(ActivityPushSapInterfaceEnum.BRANCH_QUERY_ACTIVITY, dto);
    }

    public Result pushFeeGoodsMaintenance(FreeGoodsInterfaceDto dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        MessageHeaderDto header = Optional.ofNullable(dto.getMessageHeader()).orElse(new MessageHeaderDto());
        header.setInterfacePath(ActivityPushSapInterfaceEnum.FREE_GOODS.getCode());
        header.setSender(ActivityPushSapInterfaceEnum.FREE_GOODS.getSender());
        header.setReceiver(ActivityPushSapInterfaceEnum.FREE_GOODS.getReceiver());
        if (StringUtils.isEmpty((CharSequence)header.getMessageId())) {
            header.setMessageId(UuidCrmUtil.general());
        }
        header.setSendTime(DateUtil.date_yyyyMMddHHmmss.format(new Date()));
        dto.setMessageHeader(header);
        return this.sendActivityMsgToBranch(ActivityPushSapInterfaceEnum.FREE_GOODS, dto);
    }

    private Result sendActivityMsgToBranch(ActivityPushSapInterfaceEnum interfacePath, Object dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.init();
        HashMap<String, String> headMap = new HashMap<String, String>(4);
        headMap.put("Authorization", this.secretKey);
        String json = JSON.toJSONString((Object)dto);
        ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo((Object)dto, (UrlAddressVo)this.urlAddressVo);
        String url = this.host + interfacePath.getInterfacePath();
        if (StringUtils.isNotBlank((CharSequence)this.accessId)) {
            url = url + this.accessId;
        }
        detailDto.setMethod(interfacePath.getInterfacePath());
        detailDto.setMethodMsg(interfacePath.getDesc());
        detailDto.setReqHead(JSON.toJSONString(headMap));
        this.foreignLogVoService.addOrUpdateLog(detailDto, true);
        Result result = HttpCrmUtil.post((String)url, (String)json, headMap);
        if (202 == result.getCode()) {
            result.setSuccess(true);
        }
        ForeignLogUtil.buildLogResult((ForeignLogDetailDto)detailDto, (Object)result);
        this.foreignLogVoService.addOrUpdateLog(detailDto, false);
        return result;
    }

    private void init() {
        this.urlAddressVo = this.urlApiService.getUrlAddressByAccount("sap_user_name");
        this.host = this.urlAddressVo.getUrl();
        this.accessId = this.urlAddressVo.getAccessId();
        this.accessKey = this.urlAddressVo.getAccessKey();
        this.secretKey = this.urlAddressVo.getSecretKey();
    }
}

