/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mn.third.system.sd.local.service.internal;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.auth.sdk.service.UrlApiService;
import com.biz.crm.mn.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.mn.common.base.util.HttpCrmUtil;
import com.biz.crm.mn.common.log.sdk.dto.ForeignLogDetailDto;
import com.biz.crm.mn.common.log.sdk.service.ForeignLogVoService;
import com.biz.crm.mn.common.log.sdk.util.ForeignLogUtil;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditFeeUpAccountDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditFeeUpAccountSonCompanyDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.FeePoolQueryDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.FeePoolQuerySonCompanyDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.LineOfCreditDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.MessageHeaderDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.PaymentReceiptApplyDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.PaymentReceiptQueryStatusDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.PriceAccountDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SapRedInvoiceSaleOrderCreateDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.Tpm170ReqVo;
import com.biz.crm.mn.third.system.sd.sdk.dto.Tpm170RespVo;
import com.biz.crm.mn.third.system.sd.sdk.service.SapSdApiService;
import com.biz.crm.mn.third.system.sd.sdk.vo.FeePoolQuerySonCompanyVo;
import com.biz.crm.mn.third.system.sd.sdk.vo.FeePoolQueryVo;
import com.biz.crm.mn.third.system.sd.sdk.vo.PaymentReceiptResultVo;
import com.biz.crm.mn.third.system.sd.sdk.vo.PaymentReceiptStatusResultVo;
import com.biz.crm.mn.third.system.sd.sdk.vo.ReconciliationSapDto;
import com.bizunited.nebula.common.util.JsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SapSdApiServiceImpl
implements SapSdApiService {
    private static final Logger log = LoggerFactory.getLogger(SapSdApiServiceImpl.class);
    private String host;
    private String accessKey;
    private String secretKey;
    private UrlAddressVo urlAddressVo;
    @Autowired(required=false)
    private ForeignLogVoService foreignLogVoService;
    @Autowired(required=false)
    private UrlApiService urlApiService;

    public void auditFeeUpAccount(AuditFeeUpAccountDto dto) {
        this.init();
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", this.secretKey);
        String json = JSON.toJSONString((Object)dto);
        ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo((Object)dto, (UrlAddressVo)this.urlAddressVo);
        detailDto.setMethod("/RESTAdapter/BC_TPM/SI_TPM70_EXPENSES_HQ_ASYN_OUT");
        detailDto.setMethodMsg("\u6838\u9500\u8d39\u7528\u4e0a\u8d26\u63a5\u53e3-\u603b\u90e8");
        detailDto.setReqHead(JSON.toJSONString(headMap));
        this.foreignLogVoService.addOrUpdateLog(detailDto, true);
        Result result = HttpCrmUtil.post((String)(this.host + "/RESTAdapter/BC_TPM/SI_TPM70_EXPENSES_HQ_ASYN_OUT"), (String)json, headMap);
        if (202 == result.getCode()) {
            result.setSuccess(true);
        }
        ForeignLogUtil.buildLogResult((ForeignLogDetailDto)detailDto, (Object)result);
        this.foreignLogVoService.addOrUpdateLog(detailDto, false);
    }

    public void auditFeeUpAccountSonCompany(AuditFeeUpAccountSonCompanyDto dto) {
        this.init();
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", this.secretKey);
        String json = JSON.toJSONString((Object)dto);
        ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo((Object)dto, (UrlAddressVo)this.urlAddressVo);
        detailDto.setMethod("/RESTAdapter/BC_TPM/ECC/SI_TPM80_HXFYSZ_FGS_ASYN_OUT");
        detailDto.setMethodMsg("\u6838\u9500\u8d39\u7528\u4e0a\u8d26\u63a5\u53e3-\u5206\u5b50\u516c\u53f8");
        detailDto.setReqHead(JSON.toJSONString(headMap));
        this.foreignLogVoService.addOrUpdateLog(detailDto, true);
        Result result = HttpCrmUtil.post((String)(this.host + "/RESTAdapter/BC_TPM/ECC/SI_TPM80_HXFYSZ_FGS_ASYN_OUT"), (String)json, headMap);
        if (202 == result.getCode()) {
            result.setSuccess(true);
        }
        ForeignLogUtil.buildLogResult((ForeignLogDetailDto)detailDto, (Object)result);
        this.foreignLogVoService.addOrUpdateLog(detailDto, false);
    }

    public FeePoolQueryVo feePoolQuery(FeePoolQueryDto dto) {
        this.init();
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", this.secretKey);
        String json = JSON.toJSONString((Object)dto);
        ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo((Object)dto);
        detailDto.setAccessKey(this.secretKey);
        detailDto.setMethod("/RESTAdapter/BC_TPM/SI_TPM90_POOLCHECK_HQ_SYN_OUT");
        detailDto.setMethodMsg("\u8d39\u7528\u6c60\u67e5\u8be2-\u603b\u90e8");
        detailDto.setReqHead(JSON.toJSONString(headMap));
        detailDto.setTargetMain(this.host);
        detailDto.setReqJson(JsonUtils.obj2JsonString((Object)dto));
        this.foreignLogVoService.addOrUpdateLog(detailDto, true);
        Result result = HttpCrmUtil.post((String)(this.host + "/RESTAdapter/BC_TPM/SI_TPM90_POOLCHECK_HQ_SYN_OUT"), (String)json, headMap);
        if (202 == result.getCode()) {
            result.setSuccess(true);
        }
        ForeignLogUtil.buildLogResult((ForeignLogDetailDto)detailDto, (Object)result);
        this.foreignLogVoService.addOrUpdateLog(detailDto, false);
        return (FeePoolQueryVo)JSON.parseObject((String)((String)result.getResult()), FeePoolQueryVo.class);
    }

    public FeePoolQuerySonCompanyVo feePoolQuerySonCompany(FeePoolQuerySonCompanyDto dto) {
        this.init();
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", this.secretKey);
        String json = JSON.toJSONString((Object)dto);
        ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo((Object)dto);
        detailDto.setAccessKey(this.secretKey);
        detailDto.setMethod("/RESTAdapter/BC_TPM/ECC/SI_TPM100_FYCYECX_FGS_SYN_OUT");
        detailDto.setMethodMsg("\u8d39\u7528\u6c60\u67e5\u8be2-\u5206\u5b50\u516c\u53f8");
        detailDto.setReqHead(JSON.toJSONString(headMap));
        detailDto.setTargetMain(this.host);
        detailDto.setReqJson(JsonUtils.obj2JsonString((Object)dto));
        this.foreignLogVoService.addOrUpdateLog(detailDto, true);
        Result result = HttpCrmUtil.post((String)(this.host + "/RESTAdapter/BC_TPM/ECC/SI_TPM100_FYCYECX_FGS_SYN_OUT"), (String)json, headMap);
        if (202 == result.getCode()) {
            result.setSuccess(true);
        }
        ForeignLogUtil.buildLogResult((ForeignLogDetailDto)detailDto, (Object)result);
        this.foreignLogVoService.addOrUpdateLog(detailDto, false);
        return (FeePoolQuerySonCompanyVo)JSON.parseObject((String)((String)result.getResult()), FeePoolQuerySonCompanyVo.class);
    }

    public Result priceMasterData(PriceAccountDto dto) {
        this.init();
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", this.secretKey);
        String json = JSON.toJSONString((Object)dto);
        ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo((Object)dto, (UrlAddressVo)this.urlAddressVo);
        detailDto.setMethod("/RESTAdapter/BC_TPM/ECC/SI_TPM110_BasicPrice_Asyn_OUT");
        detailDto.setMethodMsg("\u63a8\u9001\u4ef7\u683c\u4e3b\u6570\u636e");
        detailDto.setReqHead(JSON.toJSONString(headMap));
        this.foreignLogVoService.addOrUpdateLog(detailDto, true);
        Result result = HttpCrmUtil.post((String)(this.host + "/RESTAdapter/BC_TPM/ECC/SI_TPM110_BasicPrice_Asyn_OUT"), (String)json, headMap);
        if (202 == result.getCode()) {
            result.setSuccess(true);
        }
        ForeignLogUtil.buildLogResult((ForeignLogDetailDto)detailDto, (Object)result);
        this.foreignLogVoService.addOrUpdateLog(detailDto, false);
        return result;
    }

    public Result<PaymentReceiptResultVo> pushPaymentReceipt(PaymentReceiptApplyDto paymentReceiptApplyDto) {
        Field[] fields;
        Validate.notNull((Object)paymentReceiptApplyDto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.init();
        for (Field field : fields = paymentReceiptApplyDto.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(ApiModelProperty.class) || !field.getAnnotation(ApiModelProperty.class).required()) continue;
            try {
                Object o = field.get(paymentReceiptApplyDto);
                Validate.notNull((Object)o, (String)(field.getAnnotation(ApiModelProperty.class).value() + "\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", this.secretKey);
        String json = null;
        try {
            json = new ObjectMapper().writeValueAsString((Object)paymentReceiptApplyDto);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo((Object)paymentReceiptApplyDto, (UrlAddressVo)this.urlAddressVo);
        detailDto.setMethod("/RESTAdapter/BC_TPM/CE/SI_TPM180_YKYW_SYN");
        detailDto.setMethodMsg("\u7528\u6b3e\u4e1a\u52a1\u63a5\u53e3");
        detailDto.setReqHead(JSON.toJSONString(headMap));
        this.foreignLogVoService.addOrUpdateLog(detailDto, true);
        Result result = HttpCrmUtil.post((String)(this.host + "/RESTAdapter/BC_TPM/CE/SI_TPM180_YKYW_SYN"), (String)json, headMap);
        if (202 == result.getCode()) {
            result.setSuccess(true);
        }
        ForeignLogUtil.buildLogResult((ForeignLogDetailDto)detailDto, (Object)result);
        this.foreignLogVoService.addOrUpdateLog(detailDto, false);
        if (result.isSuccess()) {
            if (StrUtil.isNotBlank((CharSequence)((CharSequence)result.getResult())) && JSON.isValidObject((String)((String)result.getResult()))) {
                PaymentReceiptResultVo receiptResultVo = (PaymentReceiptResultVo)JSON.parseObject((String)((String)result.getResult()), PaymentReceiptResultVo.class);
                return Result.ok((Object)receiptResultVo);
            }
            return Result.ok((Object)new PaymentReceiptResultVo());
        }
        log.error("\u63a8\u9001\u4ed8\u6b3e\u5355\u636e\u5931\u8d25,{},{}", (Object)result.getCode(), result.getResult());
        return Result.error((String)"\u63a8\u9001\u4ed8\u6b3e\u5355\u636e\u5931\u8d25");
    }

    public Result<PaymentReceiptStatusResultVo> queryPaymentReceiptStatus(PaymentReceiptQueryStatusDto paymentReceiptQueryStatusDto) {
        Validate.notNull((Object)paymentReceiptQueryStatusDto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)paymentReceiptQueryStatusDto.getStartDate(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)paymentReceiptQueryStatusDto.getEndDate(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        long between = DateUtil.between((Date)paymentReceiptQueryStatusDto.getStartDate(), (Date)paymentReceiptQueryStatusDto.getEndDate(), (DateUnit)DateUnit.DAY);
        Validate.isTrue((between <= 30L ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u7ed3\u675f\u65f6\u95f4\u95f4\u9694\u4e0d\u80fd\u8d85\u8fc7\u4e00\u4e2a\u6708", (Object[])new Object[0]);
        this.init();
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", this.secretKey);
        String json = null;
        try {
            json = new ObjectMapper().writeValueAsString((Object)paymentReceiptQueryStatusDto);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo((Object)paymentReceiptQueryStatusDto, (UrlAddressVo)this.urlAddressVo);
        detailDto.setMethod("/RESTAdapter/BC_TPM/CE/SI_TPM160_CEZTCX_SYN");
        detailDto.setMethodMsg("\u7528\u6b3e\u4e1a\u52a1\u72b6\u6001\u67e5\u8be2\u63a5\u53e3");
        detailDto.setReqHead(JSON.toJSONString(headMap));
        this.foreignLogVoService.addOrUpdateLog(detailDto, true);
        Result result = HttpCrmUtil.post((String)(this.host + "/RESTAdapter/BC_TPM/CE/SI_TPM160_CEZTCX_SYN"), (String)json, headMap);
        if (202 == result.getCode()) {
            result.setSuccess(true);
        }
        ForeignLogUtil.buildLogResult((ForeignLogDetailDto)detailDto, (Object)result);
        this.foreignLogVoService.addOrUpdateLog(detailDto, false);
        if (result.isSuccess()) {
            if (StrUtil.isNotBlank((CharSequence)((CharSequence)result.getResult())) && JSON.isValidObject((String)((String)result.getResult()))) {
                PaymentReceiptStatusResultVo receiptResultVo = (PaymentReceiptStatusResultVo)JSON.parseObject((String)((String)result.getResult()), PaymentReceiptStatusResultVo.class);
                JSONObject jsonObject = JSON.parseObject((String)((String)result.getResult()));
                Object item1 = jsonObject.get((Object)"ITEM1");
                List details = JSON.parseArray((String)JSON.toJSONString((Object)item1), PaymentReceiptStatusResultVo.PaymentReceiptStatusDetail.class);
                receiptResultVo.setDetails(details);
                return Result.ok((Object)receiptResultVo);
            }
            return Result.ok((Object)new PaymentReceiptStatusResultVo());
        }
        log.error("\u83b7\u53d6\u4ed8\u6b3e\u5355\u636e\u5931\u8d25,{},{}", (Object)result.getCode(), result.getResult());
        return Result.error((String)"\u83b7\u53d6\u4ed8\u6b3e\u5355\u636e\u5931\u8d25");
    }

    public Result pushReconciliationToSap(ReconciliationSapDto dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.init();
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", this.secretKey);
        String json = JSON.toJSONString((Object)dto);
        ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo((Object)dto, (UrlAddressVo)this.urlAddressVo);
        detailDto.setMethod("/RESTAdapter/BC_TPM/SI_TPM150_CUSTOMERLIST_SUB_ASYN_OUT");
        detailDto.setMethodMsg("\u5bf9\u8d26\u5355\u63a8\u9001\u63a5\u53e3");
        detailDto.setReqHead(JSON.toJSONString(headMap));
        this.foreignLogVoService.addOrUpdateLog(detailDto, true);
        Result result = HttpCrmUtil.post((String)(this.host + "/RESTAdapter/BC_TPM/SI_TPM150_CUSTOMERLIST_SUB_ASYN_OUT"), (String)json, headMap);
        if (202 == result.getCode()) {
            result.setSuccess(true);
        }
        ForeignLogUtil.buildLogResult((ForeignLogDetailDto)detailDto, (Object)result);
        this.foreignLogVoService.addOrUpdateLog(detailDto, false);
        if (result.isSuccess()) {
            return Result.ok((String)"\u63a8\u9001\u5bf9\u8d26\u5355\u6210\u529f");
        }
        return Result.error((String)"\u63a8\u9001\u5bf9\u8d26\u5355\u5931\u8d25");
    }

    public Result queryLineOfCredit(LineOfCreditDataDto dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.init();
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", this.secretKey);
        String json = null;
        try {
            json = JSON.toJSONString((Object)dto);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo((Object)dto, (UrlAddressVo)this.urlAddressVo);
        detailDto.setMethod("/RESTAdapter/BC_TPM/ECC/SI_TPM120_XDEDCX_ASYN_OUT");
        detailDto.setMethodMsg("KMS\u4fe1\u8d37\u53d1\u9001\u63a5\u53e3");
        detailDto.setReqHead(JSON.toJSONString(headMap));
        this.foreignLogVoService.addOrUpdateLog(detailDto, true);
        Result result = HttpCrmUtil.post((String)(this.host + "/RESTAdapter/BC_TPM/ECC/SI_TPM120_XDEDCX_ASYN_OUT"), (String)json, headMap);
        if (202 == result.getCode()) {
            result.setSuccess(true);
        }
        ForeignLogUtil.buildLogResult((ForeignLogDetailDto)detailDto, (Object)result);
        this.foreignLogVoService.addOrUpdateLog(detailDto, false);
        if (result.isSuccess()) {
            return Result.ok((String)"\u63a8\u9001\u655e\u53e3\u7ba1\u7406\u6570\u636e\u6210\u529f");
        }
        return Result.error((String)"\u63a8\u9001\u655e\u53e3\u7ba1\u7406\u6570\u636e\u5931\u8d25");
    }

    public Result<Tpm170RespVo> pushTpm170(Tpm170ReqVo reqVo) {
        Validate.notNull((Object)reqVo, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)reqVo.getHeader(), (String)"header\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.init();
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", this.secretKey);
        String json = JSONUtil.toJsonStr((Object)reqVo);
        ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo((Object)reqVo, (UrlAddressVo)this.urlAddressVo);
        detailDto.setMethod("/RESTAdapter/BC_TPM/SI_TPM170_ACCRUEDCHARGES_SYN_OUT");
        detailDto.setMethodMsg("TPM170:\u8d39\u7528\u8ba1\u63d0\u63a5\u53e3(TPM->CE)");
        detailDto.setReqHead(JSON.toJSONString(headMap));
        this.foreignLogVoService.addOrUpdateLog(detailDto, true);
        Result result = HttpCrmUtil.post((String)(this.host + "/RESTAdapter/BC_TPM/SI_TPM170_ACCRUEDCHARGES_SYN_OUT"), (String)json, headMap);
        if (202 == result.getCode()) {
            result.setSuccess(true);
        }
        ForeignLogUtil.buildLogResult((ForeignLogDetailDto)detailDto, (Object)result);
        this.foreignLogVoService.addOrUpdateLog(detailDto, false);
        if (result.isSuccess()) {
            if (StrUtil.isNotBlank((CharSequence)((CharSequence)result.getResult())) && JSON.isValidObject((String)((String)result.getResult()))) {
                Tpm170RespVo tpm170RespVo = (Tpm170RespVo)JSONUtil.toBean((String)((String)result.getResult()), Tpm170RespVo.class);
                return Result.ok((Object)tpm170RespVo);
            }
            return Result.ok((Object)new Tpm170RespVo());
        }
        log.error("\u63a8\u9001\u8d39\u7528\u8ba1\u63d0\u5931\u8d25,{},{}", (Object)result.getCode(), result.getResult());
        return Result.error((String)"\u63a8\u9001\u8d39\u7528\u8ba1\u63d0\u5931\u8d25");
    }

    private void init() {
        this.urlAddressVo = this.urlApiService.getUrlAddressByAccount("sap_user_name");
        this.host = this.urlAddressVo.getUrl();
        this.accessKey = this.urlAddressVo.getAccessKey();
        this.secretKey = this.urlAddressVo.getSecretKey();
    }

    public void pushSapSaleOrderCreate(SapRedInvoiceSaleOrderCreateDto dto) {
        this.init();
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("Authorization", this.secretKey);
        dto.setHEADER(this.packageMsgHeader("SI_TPM200_SALEORDER_CREATE_ASYN_OUT"));
        String json = JSON.toJSONString((Object)dto);
        ForeignLogDetailDto detailDto = ForeignLogUtil.buildLogSaveInfo((Object)dto, (UrlAddressVo)this.urlAddressVo);
        detailDto.setMethod("/RESTAdapter/BC_TPM/SI_TPM200_SALEORDER_CREATE_ASYN_OUT");
        detailDto.setMethodMsg("\u7ea2\u5b57\u53d1\u7968-\u9500\u552e\u8ba2\u5355\u521b\u5efa");
        detailDto.setReqHead(JSON.toJSONString(headMap));
        this.foreignLogVoService.addOrUpdateLog(detailDto, true);
        Result result = HttpCrmUtil.post((String)(this.host + "/RESTAdapter/BC_TPM/SI_TPM200_SALEORDER_CREATE_ASYN_OUT"), (String)json, headMap);
        if (202 == result.getCode()) {
            result.setSuccess(true);
        }
        ForeignLogUtil.buildLogResult((ForeignLogDetailDto)detailDto, (Object)result);
        this.foreignLogVoService.addOrUpdateLog(detailDto, false);
    }

    private MessageHeaderDto packageMsgHeader(String interfacePath) {
        MessageHeaderDto headerDto = new MessageHeaderDto();
        headerDto.setMessageId(UUID.randomUUID().toString().replace("-", ""));
        headerDto.setInterfacePath(interfacePath);
        headerDto.setSender("TPM");
        headerDto.setReceiver("ECC");
        headerDto.setSendTime(String.valueOf(System.currentTimeMillis()));
        return headerDto;
    }
}

