package com.biz.crm.sfa.business.sign.in.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupUserPageDto;
import com.biz.crm.sfa.business.sign.in.sdk.service.SignInGroupVoService;
import com.biz.crm.sfa.business.sign.in.sdk.vo.SignInGroupVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 签到组: SignInGroupVo: 签到组配置
 *
 * @author ning.zhang
 * @date 2022/5/9
 */
@Slf4j
@RestController
@RequestMapping("/v1/signIn/signInGroup")
@Api(tags = "签到组: SignInGroupVo: 签到组配置")
public class SignInGroupVoController {

  @Autowired
  private SignInGroupVoService signInGroupVoService;

  /**
   * 通过ID获取签到组详细信息
   *
   * @param id 签到组ID
   * @return 签到组信息
   */
  @ApiOperation(value = "通过ID获取签到组详细信息")
  @GetMapping("/findById")
  public Result<SignInGroupVo> findById(@RequestParam(value = "id", required = false) @ApiParam(name = "id", value = "主键ID") String id) {
    try {
      return Result.ok(this.signInGroupVoService.findById(id));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 移动端-当前用户签到组分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<SignInGroupVo> 签到组分页信息
   */
  @ApiOperation(value = "移动端-当前用户签到组分页列表")
  @GetMapping("/findBySignInGroupUserPageDto")
  public Result<Page<SignInGroupVo>> findBySignInGroupUserPageDto(@PageableDefault(50) Pageable pageable,
                                                                  @ApiParam(name = "SignInGroupPageDto", value = "分页Dto") SignInGroupUserPageDto dto) {
    try {
      return Result.ok(this.signInGroupVoService.findBySignInGroupUserPageDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
