package com.biz.crm.sfa.business.sign.in.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 签到组地点实体类
 *
 * @author ning.zhang
 * @date 2022/5/9
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignInGroupPlaceEntity", description = "签到组地点实体类")
@Entity
@TableName("sfa_sign_in_group_place")
@Table(name = "sfa_sign_in_group_place", indexes = {
    @Index(name = "sfa_sign_in_group_place_index1", columnList = "group_id"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_sign_in_group_place", comment = "签到组地点表")
public class SignInGroupPlaceEntity extends UuidOpEntity {

  private static final long serialVersionUID = -3406265993256852972L;

  /**
   * 签到组ID
   */
  @ApiModelProperty("签到组ID")
  @Column(name = "group_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '签到组ID'")
  private String groupId;

  /**
   * 地点序号
   */
  @ApiModelProperty("地点序号")
  @Column(name = "place_no", length = 64, columnDefinition = "VARCHAR(64) COMMENT '地点序号'")
  private String placeNo;

  /**
   * 地点名称
   */
  @ApiModelProperty("地点名称")
  @Column(name = "place_name", nullable = false, length = 100, columnDefinition = "VARCHAR(100) NOT NULL COMMENT '地点名称'")
  private String placeName;

  /**
   * 地点地址
   */
  @ApiModelProperty("地点地址")
  @Column(name = "place_address", nullable = false, columnDefinition = "VARCHAR(255) NOT NULL COMMENT '地点地址'")
  private String placeAddress;

  /**
   * 地点经度
   */
  @ApiModelProperty("地点经度")
  @Column(name = "place_longitude", columnDefinition = "decimal(12,8) COMMENT '地点经度'")
  private BigDecimal placeLongitude;

  /**
   * 地点纬度
   */
  @ApiModelProperty("地点纬度")
  @Column(name = "place_latitude", columnDefinition = "decimal(12,8) COMMENT '地点纬度'")
  private BigDecimal placeLatitude;

  /**
   * 地点范围(单位米)
   */
  @ApiModelProperty("地点范围(单位米)")
  @Column(name = "place_range", columnDefinition = "INT(7) COMMENT '地点范围(单位米)'")
  private Integer placeRange;
}
