package com.biz.crm.sfa.business.sign.in.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 签到组范围实体类
 *
 * @author ning.zhang
 * @date 2022/5/9
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignInGroupScopeEntity", description = "签到组范围实体类")
@Entity
@TableName("sfa_sign_in_group_scope")
@Table(name = "sfa_sign_in_group_scope", indexes = {
    @Index(name = "sfa_attendance_rule_group_scope_index1", columnList = "group_id"),
    @Index(name = "sfa_attendance_rule_group_scope_index2", columnList = "scope_code,scope_type"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_sign_in_group_scope", comment = "签到组范围表")
public class SignInGroupScopeEntity extends UuidOpEntity {

  private static final long serialVersionUID = -7414850892747921796L;

  /**
   * 签到组ID
   */
  @ApiModelProperty("签到组ID")
  @Column(name = "group_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '签到组ID'")
  private String groupId;

  /**
   * 范围编码
   */
  @ApiModelProperty("范围编码")
  @Column(name = "scope_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '范围编码'")
  private String scopeCode;

  /**
   * 范围类型(org:组织;user:人员)
   * @see com.biz.crm.sfa.business.sign.in.sdk.enums.SignInScopeType
   */
  @ApiModelProperty("范围类型(org:组织;user:人员)")
  @Column(name = "scope_type", length = 32, nullable = false, columnDefinition = "VARCHAR(32) NOT NULL COMMENT '范围类型(org:组织;user:人员)'")
  private String scopeType;
}
