package com.biz.crm.sfa.business.sign.in.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 签到组-签到类型实体类
 *
 * @author ning.zhang
 * @date 2022/5/9
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignInGroupEntity", description = "签到组-签到类型实体类")
@Entity
@TableName("sfa_sign_in_group_type")
@Table(name = "sfa_sign_in_group_type", indexes = {
    @Index(name = "sfa_sign_in_group_type_index1", columnList = "group_id,type_id", unique = true),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_sign_in_group_type", comment = "签到组-签到类型实体类表")
public class SignInGroupTypeEntity extends UuidEntity {

  private static final long serialVersionUID = -1015113288730183446L;

  /**
   * 签到组ID
   */
  @ApiModelProperty("签到组ID")
  @Column(name = "group_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '签到组ID'")
  private String groupId;

  /**
   * 签到类型ID
   */
  @ApiModelProperty("签到类型ID")
  @Column(name = "type_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '签到类型ID'")
  private String typeId;
}
