package com.biz.crm.sfa.business.sign.in.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupEntity;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupPageDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 签到组表的mybatis-plus接口类 {@link SignInGroupEntity}
 *
 * @author ning.zhang
 * @date 2022-05-09 11:42:28
 */
public interface SignInGroupMapper extends BaseMapper<SignInGroupEntity> {

  /**
   * 通过签到组ID集合获取签到组信息
   *
   * @param ids 签到组ID集合
   * @return 签到组信息
   */
  List<SignInGroupEntity> findByIds(@Param("ids") List<String> ids);

  /**
   * 签到组分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<SignInGroupEntity> 签到组分页信息
   */
  Page<SignInGroupEntity> findByConditions(Page<SignInGroupEntity> page, @Param("dto") SignInGroupPageDto dto);

}

