package com.biz.crm.sfa.business.sign.in.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupDateEntity;
import com.biz.crm.sfa.business.sign.in.local.mapper.SignInGroupDateMapper;
import org.springframework.stereotype.Component;

/**
 * 签到组日期表的数据库访问类 {@link SignInGroupDateEntity}
 *
 * @author ning.zhang
 * @date 2022-05-09 11:42:44
 */
@Component
public class SignInGroupDateRepository extends ServiceImpl<SignInGroupDateMapper, SignInGroupDateEntity> {

  /**
   * 通过删除签到组ID删除签到组日期
   *
   * @param groupId 签到组ID
   */
  public void deleteByGroupId(String groupId) {
    this.lambdaUpdate()
        .eq(SignInGroupDateEntity::getGroupId, groupId)
        .remove();
  }
}
