package com.biz.crm.sfa.business.sign.in.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupEntity;
import com.biz.crm.sfa.business.sign.in.local.mapper.SignInGroupMapper;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupPageDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 签到组表的数据库访问类 {@link SignInGroupEntity}
 *
 * @author ning.zhang
 * @date 2022-05-09 11:42:29
 */
@Component
public class SignInGroupRepository extends ServiceImpl<SignInGroupMapper, SignInGroupEntity> {

  /**
   * 通过签到组ID集合获取签到组信息
   *
   * @param ids 签到组ID集合
   * @return 签到组信息
   */
  public List<SignInGroupEntity> findByIds(List<String> ids) {
    return this.baseMapper.findByIds(ids);
  }

  /**
   * 批量更新启用禁用状态
   *
   * @param ids          ID集合
   * @param enableStatus 启用禁用状态
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(SignInGroupEntity::getId, ids)
        .set(SignInGroupEntity::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 批量删除
   *
   * @param ids ID集合
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(SignInGroupEntity::getId, ids)
        .set(SignInGroupEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 签到组分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<SignInGroupEntity> 签到组分页信息
   */
  public Page<SignInGroupEntity> findByConditions(Pageable pageable, SignInGroupPageDto dto) {
    Page<SignInGroupEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }
}
