package com.biz.crm.sfa.business.sign.in.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.sign.in.local.entity.SignInTypeEntity;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInTypeDto;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInTypePageDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 签到类型表服务接口
 *
 * @author ning.zhang
 * @date 2022-05-09 11:43:32
 */
public interface SignInTypeService {

  /**
   * 创建签到类型
   *
   * @param dto 请求参数dto
   * @return 签到类型实体
   */
  SignInTypeEntity create(SignInTypeDto dto);

  /**
   * 更新签到类型
   *
   * @param dto 请求参数dto
   * @return 签到类型实体
   */
  SignInTypeEntity update(SignInTypeDto dto);

  /**
   * 批量删除签到类型
   *
   * @param ids 签到类型id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 签到类型分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<SignInTypeEntity> 签到类型分页信息
   */
  Page<SignInTypeEntity> findByConditions(Pageable pageable, SignInTypePageDto dto);

  /**
   * 通过签到类型ID获取签到类型信息
   *
   * @param id 签到类型ID
   * @return 签到类型信息
   */
  SignInTypeEntity findById(String id);
}
