package com.biz.crm.sfa.business.sign.in.local.service.internal;

import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupPlaceEntity;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInGroupPlaceRepository;
import com.biz.crm.sfa.business.sign.in.local.service.SignInGroupPlaceService;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 签到组地点表服务实现类
 *
 * @author ning.zhang
 * @date 2022-05-09 11:42:58
 */
@Slf4j
@Service("signInGroupPlaceService")
public class SignInGroupPlaceServiceImpl implements SignInGroupPlaceService {

  @Autowired
  private SignInGroupPlaceRepository signInGroupPlaceRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void update(SignInGroupDto dto) {
    Validate.notBlank(dto.getId(), "签到组ID不能为空");
    this.signInGroupPlaceRepository.deleteByGroupId(dto.getId());
    if (CollectionUtils.isEmpty(dto.getPlaceList())) {
      return;
    }
    this.updateValidation(dto);
    List<SignInGroupPlaceEntity> entities = dto.getPlaceList().stream().map(placeDto -> {
      SignInGroupPlaceEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(placeDto, SignInGroupPlaceEntity.class, HashSet.class, ArrayList.class);
      entity.setGroupId(dto.getId());
      return entity;
    }).collect(Collectors.toList());
    this.signInGroupPlaceRepository.saveBatch(entities);
  }

  /**
   * 在修改signInGroupPlace模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param dto 检查对象
   */
  private void updateValidation(SignInGroupDto dto) {
    Validate.notBlank(dto.getElectronFenceType(), "缺失打卡范围类型");
    dto.getPlaceList().forEach(placeDto -> {
      int placeNo = dto.getPlaceList().indexOf(placeDto) + 1;
      placeDto.setPlaceNo(String.valueOf(placeNo));
      Validate.notBlank(placeDto.getPlaceName(), String.format("序号%s,缺失地点名称", placeNo));
      Validate.notBlank(placeDto.getPlaceAddress(), String.format("序号%s,缺失地点地址", placeNo));
      Validate.isTrue(Objects.nonNull(placeDto.getPlaceRange()) && placeDto.getPlaceRange() > 0
          , String.format("序号%s,地点范围数据错误", placeNo));
      Validate.notNull(placeDto.getPlaceLatitude(), String.format("序号%s,缺失地点纬度", placeNo));
      Validate.notNull(placeDto.getPlaceLongitude(), String.format("序号%s,缺失地点经度", placeNo));
    });
  }
}
