package com.biz.crm.sfa.business.sign.in.local.service.internal;

import com.biz.crm.sfa.business.sign.in.local.entity.SignInGroupScopeEntity;
import com.biz.crm.sfa.business.sign.in.local.repository.SignInGroupScopeRepository;
import com.biz.crm.sfa.business.sign.in.local.service.SignInGroupScopeService;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupDto;
import com.biz.crm.sfa.business.sign.in.sdk.dto.SignInGroupScopeDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 签到组范围表服务实现类
 *
 * @author ning.zhang
 * @date 2022-05-09 11:43:09
 */
@Slf4j
@Service("signInGroupScopeService")
public class SignInGroupScopeServiceImpl implements SignInGroupScopeService {

  @Autowired
  private SignInGroupScopeRepository signInGroupScopeRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void update(SignInGroupDto dto) {
    Validate.notBlank(dto.getId(), "签到组ID不能为空");
    this.signInGroupScopeRepository.deleteByGroupId(dto.getId());
    if (CollectionUtils.isEmpty(dto.getScopeList())) {
      return;
    }
    this.updateValidation(dto);
    List<SignInGroupScopeEntity> entities = dto.getScopeList().stream().map(scopeDto -> {
      SignInGroupScopeEntity entity = this.nebulaToolkitService.copyObjectByWhiteList(scopeDto, SignInGroupScopeEntity.class, HashSet.class, ArrayList.class);
      entity.setGroupId(dto.getId());
      return entity;
    }).collect(Collectors.toList());
    this.signInGroupScopeRepository.saveBatch(entities);
  }

  /**
   * 在修改signInGroupScope模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   *
   * @param dto 检查对象
   */
  private void updateValidation(SignInGroupDto dto) {
    for (SignInGroupScopeDto scopeDto : dto.getScopeList()) {
      Validate.notBlank(scopeDto.getScopeCode(), "缺失范围编码");
      Validate.notBlank(scopeDto.getScopeType(), "缺失范围类型");
    }
  }
}
